
package com.bizvane.mktcenter.feign.api.mobile;

import com.bizvane.mktcenter.feign.vo.req.ActivityFortuneWheelReceivePrizeReqVO;
import com.bizvane.mktcenter.feign.vo.req.MobileMktFortuneWheelReqVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mobile/activityFortuneWheel")
public interface MobileActivityFortuneWheelFeign {

    @ApiOperation(value = "获取大转盘活动详情")
    @GetMapping("/getDetail")
    ResponseData<QueryDetailFortuneWheelRespVO> getDetail(@RequestParam("mktActivityCode") String mktActivityCode);

    @ApiOperation(value = "获取会员的积分和活动信息")
    @PostMapping("/getFortuneWheelByMbr")
    ResponseData<QueryFortuneWheelByMbrRespVO> getFortuneWheelByMbr(@RequestBody MobileMktFortuneWheelReqVO reqVO);

    @ApiOperation(value = "参与大转盘活动")
    @PostMapping("/join")
    ResponseData<QueryDetailFortuneWheelPrizeRespVO> join(@RequestBody MobileMktFortuneWheelReqVO reqVO);

    @ApiOperation(value = "获取当前会员中奖记录")
    @PostMapping("/winRecordPage")
    ResponseData<PageInfo<QueryFortuneWheelWinRecordPageRespVO>> winRecordPage(@RequestBody MobileMktFortuneWheelReqVO reqVO);

    @ApiOperation(value = "获取大转盘活动中奖记录")
    @GetMapping("/getTopWinRecord")
    ResponseData<List<QueryFortuneWheelTopWinRecordRespVO>> getTopWinRecord(@RequestParam("mktActivityCode") String mktActivityCode);

    @ApiOperation(value = "领取大转盘奖品")
    @PostMapping("/receivePrize")
    ResponseData<String> receivePrize(@RequestBody ActivityFortuneWheelReceivePrizeReqVO reqVO);
}
