package com.bizvane.mktcenter.feign.constants;

import lombok.Getter;

public class Constants {

    @Getter
    public enum ActivityStatusEnum {
        ACTIVITY_STATUS_PENDING(1, "未开始"),
        ACTIVITY_STATUS_EXECUTING(2, "进行中"),
        ACTIVITY_STATUS_FINISHED(3, "已结束"),
        ACTIVITY_STATUS_DISABLED(4, "已暂停");

        final private int code;
        final private String name;

        ActivityStatusEnum(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public static ActivityStatusEnum getActivityStatusEnum(int code) {
            for (ActivityStatusEnum activityStatusEnum : ActivityStatusEnum.values()) {
                if (activityStatusEnum.getCode() == code) {
                    return activityStatusEnum;
                }
            }
            return null;
        }
    }

    @Getter
    public enum ActivityCheckStatusEnum {
        AUDIT_STATUS_PENDING(1, "待审核"),
        AUDIT_STATUS_AUDITING(2, "审核中"),
        AUDIT_STATUS_AUDITED(3, "已审核"),
        AUDIT_STATUS_REJECTED(4, "已驳回"),
        AUDIT_STATUS_CLOSED(5, "审核关闭");

        final private int code;
        final private String name;

        ActivityCheckStatusEnum(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public static ActivityCheckStatusEnum getCheckStatusEnum(int code) {
            for (ActivityCheckStatusEnum checkStatusEnum : ActivityCheckStatusEnum.values()) {
                if (checkStatusEnum.getCode() == code) {
                    return checkStatusEnum;
                }
            }
            return null;
        }
    }
}
