package com.bizvane.mktcenter.feign.vo.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
public class AddOrUpdateMktPopupAdvertisementReqVO extends BackendLoginBO {

    @ApiModelProperty(value = "弹窗广告系统code")
    private String popupAdvertisementCode;

    @ApiModelProperty(value = "会员条件类型  1全部会员 2会员分组")
    private Integer mbrConditionType;

    @ApiModelProperty(value = "关联的会员分组系统code")
    private String mbrGroupDefCode;

    @ApiModelProperty(value = "投放页面：1.会员中心首页")
    private Integer popupWebType;

    @ApiModelProperty(value = "投放开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @ApiModelProperty(value = "投放结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @ApiModelProperty(value = "投放频率：0=永久一次；1=每次进入")
    private Integer frequencyType;

    @ApiModelProperty(value = "广告名称")
    private String advertisementName;

    @ApiModelProperty(value = "广告图片路径")
    private String advertisementImgUrl;

    @ApiModelProperty(value = "图片高度，单位px")
    private Integer popupImgHeight;

    @ApiModelProperty(value = "图片宽度，单位px")
    private Integer popupImgWeight;

    @ApiModelProperty(value = "跳转路径")
    private String linkUrl;

    @ApiModelProperty(value = "跳转路径名称")
    private String linkUrlName;

    @ApiModelProperty(value = "投放状态 1待投放 2投放中 3已结束 4已关闭")
    private Integer popupStatus;

    @ApiModelProperty(value = "优先级:值越小，越靠前")
    private Integer sort;
}
