package com.bizvane.mktcenter.feign.api.mobile;

import com.bizvane.mktcenter.feign.vo.req.mobile.MobileStaffBenefitPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryStaffBenefitDetailRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryStaffBenefitTypeRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mobileStaffBenefit")
public interface MobileStaffBenefitFeign {

    @GetMapping("getStaffBenefitTypeList")
    ResponseData<List<QueryStaffBenefitTypeRespVO>> getStaffBenefitTypeList();

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryStaffBenefitDetailRespVO>> pageList(@RequestBody MobileStaffBenefitPageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryStaffBenefitDetailRespVO> getDetail(@RequestParam("mktStaffBenefitTypeCode") String mktStaffBenefitTypeCode);
}
