package com.bizvane.mktcenter.feign.vo.resp.mobile;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
public class QueryPointsLotteryPrizeDetailRespVO {

    @ApiModelProperty(value = "活动系统编号code")
    private String mktActivityCode;

    @ApiModelProperty(value = "活动开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @ApiModelProperty(value = "活动结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @ApiModelProperty(value = "商品名称")
    private String prizeName;

    @ApiModelProperty(value = "商品图片")
    private String prizeImage;

    @ApiModelProperty(value = "商品价格")
    private Integer prizePrice;

    @ApiModelProperty(value = "商品说明")
    private String prizeInfo;
}
