package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktActivitySignInReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivitySignInAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivitySignInRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 签到奖励规则表 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-12
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktActivitySignInPrize")
public interface TMktActivitySignInPrizeFeign {
    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktActivitySignInReqVO reqVO);

    @PostMapping("/analysisPageList")
    ResponseData<PageInfo<QueryActivitySignInAnalysisPageRespVO>> analysisPageList(@RequestBody QueryActivityAnalysisPageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryDetailActivitySignInRespVO> getDetail(@RequestParam("mktActivityCode") String mktActivityCode);

}

