package com.bizvane.mktcenter.feign.api.mobile;

import com.bizvane.mktcenter.feign.vo.req.MktTaskVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.MobileQueryTaskDetailReqVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.MobileQueryTaskListReqVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.MobileQueryTaskListRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mobile/mktTask")
public interface MobileMktTaskFeign {

    @ApiOperation(value = "获取任务列表")
    @PostMapping("/getMktTaskList")
    ResponseData<List<MobileQueryTaskListRespVO>> getMktTaskList(@RequestBody MobileQueryTaskListReqVO reqVO);

    @ApiOperation(value = "获取任务详情")
    @PostMapping("/getDetail")
    ResponseData<MktTaskVO> getDetail(@RequestBody MobileQueryTaskDetailReqVO reqVO);
}
