package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.QueryTaskAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktTaskImproveProfileReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailTaskImproveProfileRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskImproveProfileAnalysisPageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 营销任务 - 完善资料 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-18
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktTaskImproveProfile")
public interface TMktTaskImproveProfileFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktTaskImproveProfileReqVO reqVO);

    @PostMapping("/analysisPageList")
    ResponseData<PageInfo<QueryTaskImproveProfileAnalysisPageRespVO>> analysisPageList(@RequestBody QueryTaskAnalysisPageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryDetailTaskImproveProfileRespVO> getDetail(@RequestParam("mktTaskCode") String mktTaskCode);
}

