package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktActivityBirthdayReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityBirthdayAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityBirthdayRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 活动表-会员消费 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-11
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktActivityBirthday")
public interface TMktActivityBirthdayFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktActivityBirthdayReqVO reqVO);

    @PostMapping("/pageAnalysisList")
    ResponseData<PageInfo<QueryActivityBirthdayAnalysisPageRespVO>> pageAnalysisList(@RequestBody QueryActivityAnalysisPageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryDetailActivityBirthdayRespVO> getDetail(@RequestParam("mktActivityCode") String mktActivityCode);

}

