/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.cache;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bizvane.message.cache.entity.TemplateCacheBean;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.dao.TemplateDao;
import com.bizvane.message.entity.Template;
import com.bizvane.message.utils.Constant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class TemplateCacheComponent {
    private static final Logger log = LoggerFactory.getLogger(TemplateCacheComponent.class);
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    public static final String MESSAGE_TEMPLATE_CONFIG = "message_gateway::template::";

    public TemplateCacheBean get(String merchantId, String channelType, String templateCode) throws MessageException {
        log.info("\u83b7\u53d6\u6a21\u677f\u7f13\u5b58\u7684\u5165\u53c2: merchantId:{}  channelType:{}  templateCode:{}", new Object[]{merchantId, channelType, templateCode});
        Object object = this.redisTemplate.opsForValue().get((Object)(MESSAGE_TEMPLATE_CONFIG + merchantId + "_" + channelType + "_" + templateCode));
        if (object != null) {
            log.info("\u83b7\u53d6\u5230\u4e86\u7f13\u5b58\u7684\u7ed3\u679c");
            return (TemplateCacheBean)JSON.parseObject((String)((String)object), TemplateCacheBean.class);
        }
        TemplateCacheBean bean = new TemplateCacheBean();
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"merchant_id", (Object)merchantId);
        wrapper.eq((Object)"channel_id", (Object)(merchantId + "_" + channelType));
        wrapper.eq((Object)"template_id", (Object)templateCode);
        wrapper.eq((Object)"valid", (Object)Constant.ONE);
        Template template = (Template)this.templateDao.selectOne((Wrapper)wrapper);
        if (template == null) {
            return null;
        }
        if (template.getStatus().equals(Constant.ONE) || template.getStatus().equals(Constant.TWO)) {
            return this.set(template);
        }
        BeanUtils.copyProperties((Object)template, (Object)bean);
        bean.setCreateTime(DateUtil.format((Date)template.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        bean.setAuditReason(template.getReason());
        bean.setTemplateCode(template.getTemplateId());
        return bean;
    }

    public TemplateCacheBean set(Template template) {
        log.info("\u4fdd\u5b58\u6a21\u677f\u7f13\u5b58:{}", (Object)JSON.toJSONString((Object)template));
        Assert.notBlank((CharSequence)template.getChannelId(), (String)"\u4fdd\u5b58\u6a21\u677f\u7f13\u5b58\u7684ChannelId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)template.getTemplateId(), (String)"\u4fdd\u5b58\u6a21\u677f\u7f13\u5b58\u7684TemplateId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TemplateCacheBean cache = new TemplateCacheBean();
        BeanUtils.copyProperties((Object)template, (Object)cache);
        cache.setCreateTime(DateUtil.format((Date)template.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        cache.setAuditReason(template.getReason());
        cache.setTemplateCode(template.getTemplateId());
        this.redisTemplate.opsForValue().set((Object)(MESSAGE_TEMPLATE_CONFIG + template.getChannelId() + "_" + template.getTemplateId()), (Object)JSON.toJSONString((Object)cache), 2L, TimeUnit.DAYS);
        return cache;
    }
}

