package com.bizvane.messagefacade.interfaces;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.messagebase.common.constants.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * 短信通用消息
 *
 * @author liangzanwen
 * 2018年8月14日下午8:22:40
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/messageParamConvert")
@Api(value = "消息通知会员基础字段转换", tags = {"消息通知会员基础字段转换"})
public interface MessageParamConvertServiceFeign {

	@ApiOperation(value = "短信活动消费模板替换会员基础字段")
	@PostMapping("/smsTemplateParamConvert")
	ResponseData<String> smsTemplateParamConvert(@RequestBody JSONObject jsonObject);

	@ApiOperation(value = "批量会员模板替换会员基础字段")
	@PostMapping("/batchTemplateParamConvert")
	ResponseData<List<JSONObject>> batchTemplateParamConvert(@RequestBody JSONObject jsonObject);
}
