package com.bizvane.messagefacade.interfaces;

import com.bizvane.messagefacade.models.vo.EmailConfigVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @Author: Lijc
 * @Time: 2019-10-22 20:48:30
 * 发送邮箱
 */
@FeignClient(value="${feign.client.message.name}",path="${feign.client.message.path}/email")
public interface SendEmailFeign {
    /**
     * 发送邮箱
     * @param vo
     * @return
     */
    @RequestMapping(value ="/sendEmail",method = RequestMethod.POST)
    ResponseData<Integer> sendEmail(@RequestBody EmailConfigVO vo);

}
