package com.bizvane.messagefacade.models.vo.vg.subscribe;

import com.alibaba.fastjson.annotation.JSONField;
import com.bizvane.messagefacade.enums.vg.WechatSubscribeFieldEnum;
import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 *
 * {@link com.bizvane.messagefacade.enums.vg.subscribefield.CouponBagReceiveFieldEnum}
 */
@Data
public class CouponBagReceiveMessageVO extends CouponMessageVO {

    @JSONField(name = "FIELD_MEMBER_PHONE")
    @JsonProperty(value = "FIELD_MEMBER_PHONE")
    private String FIELD_MEMBER_PHONE;

    @JSONField(name = "FIELD_MEMBER_CODE")
    @JsonProperty(value = "FIELD_MEMBER_CODE")
    private String FIELD_MEMBER_CODE;

    @JSONField(name = "FIELD_MEMBER_BAG_NAME")
    @JsonProperty(value = "FIELD_MEMBER_BAG_NAME")
    private String FIELD_MEMBER_BAG_NAME;

    /**
     * 此处时间
     */
    @DateTimeFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "FIELD_BOOKED_TIME")
    @JsonProperty(value = "FIELD_BOOKED_TIME")
    private Date FIELD_BOOKED_TIME;


    @JSONField(name = "FIELD_TEXT")
    @JsonProperty(value = "FIELD_TEXT")
    private String FIELD_TEXT;

}
