package com.bizvane.messagefacade.interfaces;

import com.bizvane.messagebase.model.po.MsgWxTempPO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/wechatNewTem")
@Api(value = "微信模板消息", tags = {"微信模板消息"})
public interface WechatNewTemServiceFeign {

    @PostMapping("/saveNewWxTemplate")
    ResponseData<MsgWxTempPO> saveNewWxTemplate(@RequestBody MsgWxTempPO msgWxTempPO);

    @RequestMapping(value = "/getWxTemplateById",method = RequestMethod.POST)
    ResponseData<MsgWxTempPO> getWxTemplateById(@RequestParam("wxMessageTempId") Long wxMessageTempId);
}
