package com.bizvane.messagefacade.interfaces;


import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.bizvane.messagefacade.models.vo.vg.SubscribeMessageVO;
import com.bizvane.messagefacade.models.vo.vg.subscribe.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/wechatAppletSubscirbeMessage")
@Api(value = "券相关模板消息", tags = {"API"})
public interface WechatAppletSubscirbeMessageServiceFeign{

    /**
     * 券到账提醒
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "券到账提醒")
    @RequestMapping(value = "/couponReceive", method = RequestMethod.POST)
    ResponseData<String> couponReceive(@RequestBody SubscribeMessageVO<CouponReceiveMessageVO> vo);

    /**
     * 券到期提醒
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "券到期提醒")
    @RequestMapping(value = "/couponExpire", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> couponExpire(@RequestBody SubscribeMessageVO<CouponExpireMessageVO> vo);

    /**
     * 券使用提醒
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "券使用")
    @RequestMapping(value = "/couponUse", method = RequestMethod.POST)
    ResponseData<String> couponUse(@RequestBody SubscribeMessageVO<CouponUseMessageVO> vo);


    /**
     * 会员升级消息
     *
     * @param subscribeMessageVO
     * @return
     */
    @PostMapping(value = "/memeberUpgrade")
    ResponseData<String> memeberUpgrade(@RequestBody SubscribeMessageVO<MemeberUpgradeMessageVO> subscribeMessageVO);

    /**
     * 会员降级消息
     *
     * @param subscribeMessageVO
     * @return
     */
    @PostMapping(value = "/memeberDowngrade")
    ResponseData<String> memeberDowngrade(@RequestBody SubscribeMessageVO<MemeberDowngradeMessageVO> subscribeMessageVO);

    /**
     * 积分到账消息
     *
     * @param subscribeMessageVO
     * @return
     */
    @PostMapping(value = "/integralAdd")
    ResponseData<String> integralAdd(@RequestBody SubscribeMessageVO<IntegralAddMessageVO> subscribeMessageVO);

    /**
     * 活动开始消息
     *
     * @param subscribeMessageVO
     * @return
     */
    @PostMapping(value = "/activityStart")
    ResponseData<String> activityStart(@RequestBody SubscribeMessageVO<ActivityStartMessageVO> subscribeMessageVO);


    /**
     * 活动签到消息
     *
     * @param subscribeMessageVO
     * @return
     */
    @PostMapping(value = "/activityMemberSign")
    ResponseData<String> activityMemberSign(@RequestBody SubscribeMessageVO<ActivityMemberSignMessageVO> subscribeMessageVO);

    /**
     * 积分秒杀开始消息
     *
     * @param subscribeMessageVO
     * @return
     */
    @PostMapping(value = "/integralSeckillStartMessage")
    ResponseData<String> integralSeckillStartMessage(@RequestBody SubscribeMessageVO<IntegralSeckillStartMessageVO> subscribeMessageVO);

    /***
     * 积分发货消息
     *
     * @param subscribeMessageVO
     * @return
     */
    @PostMapping(value = "/integralOrderSendMessage")
    ResponseData<String> integralOrderSendMessage(@RequestBody SubscribeMessageVO<IntegralOrderSendMessageVO> subscribeMessageVO);


    /**
     * 预设营销消息
     *
     * @param subscribeMessageVO
     * @return
     */
    @PostMapping(value = "/preset")
    ResponseData<String> preset(@RequestBody SubscribeMessageVO<PresetMessageVO> subscribeMessageVO);
}
