package com.bizvane.messagefacade.enums.vg;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum WechatSubscribeTypeEnum {

    COUPON_RECEIVE("COUPON","COUPON_RECEIVE","优惠券入账通知"),
    COUPON_EXPIRE("COUPON","COUPON_EXPIRE","优惠券到期通知"),
    COUPON_USE("COUPON","COUPON_USE","优惠券使用通知"),
    MEMEBER_UPGRADE("MEMBER","MEMEBER_UPGRADE","会员升级通知"),
    MEMEBER_DOWNGRADE("MEMBER","MEMEBER_DOWNGRADE","会员降级通知"),
    INTEGRAL_ADD("INTEGRAL","INTEGRAL_ADD","积分入账通知"),
    ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE("ACTIVITY","ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE","活动开始通知"),
    MEMBER_SIGN("ACTIVITY","MEMBER_SIGN","会员签到提醒"),
    INTEGRAL_SECKILL_START("INTEGRAL_SHOP","INTEGRAL_SECKILL_START","秒杀开始通知"),
    INTEGRAL_ORDER_SEND("INTEGRAL_SHOP","INTEGRAL_ORDER_SEND","商品发货通知"),
    PRESET("PRESET","PRESET","预置营销消息")
    ;

    private String businessType;

    private String templateType;

    private String templateName;

    WechatSubscribeTypeEnum(String businessType, String templateType, String templateName) {
        this.businessType = businessType;
        this.templateType = templateType;
        this.templateName = templateName;
    }

    public String getBusinessType() {
        return businessType;
    }

    public String getTemplateType() {
        return templateType;
    }

    public String getTemplateName() {
        return templateName;
    }

    public static List<String> getTemplateTypeList(){
        return Arrays.stream(WechatSubscribeTypeEnum.values()).map(WechatSubscribeTypeEnum::getTemplateType).collect(Collectors.toList());
    }
}
