package com.bizvane.messagefacade.models.vo.vg.subscribe;

import com.alibaba.fastjson.annotation.JSONField;
import com.bizvane.messagefacade.models.vo.IntegralMessageVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 *
 * {@link com.bizvane.messagefacade.enums.vg.subscribefield.IntegralAddFieldEnum}
 */
@Data
public class IntegralAddMessageVO extends IntegralMessageVO {

    @JSONField(name = "FIELD_MEMBER_CODE")
    private String FIELD_MEMBER_CODE;


    @JSONField(name = "FIELD_TEXT")
    private String FIELD_TEXT;


    @JSONField(name = "FIELD_INTEGRAL_INCOME_NUM")
    private Integer FIELD_INTEGRAL_INCOME_NUM;

    /**
     * 此处时间
     */
    @DateTimeFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "FIELD_INTEGRAL_INCOME_TIME")
    private Date FIELD_INTEGRAL_INCOME_TIME;

    @JSONField(name = "FIELD_PERSONAL_INTEGRAL")
    private Integer FIELD_PERSONAL_INTEGRAL;

    @JSONField(name = "FIELD_INTEGRAL_CHANG_TYPE")
    private String FIELD_INTEGRAL_CHANG_TYPE;

}
