package com.bizvane.messagefacade.models.vo.vg.subscribe;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 *
 * {@link com.bizvane.messagefacade.enums.vg.subscribefield.CouponExpireFieldEnum}
 */
@Data
public class CouponExpireMessageVO extends com.bizvane.messagefacade.models.vo.CouponMessageVO {

    @JSONField(name = "FIELD_MEMBER_CODE")
    private String FIELD_MEMBER_CODE;

    @JSONField(name = "FIELD_COUPON_NAME")
    private String FIELD_COUPON_NAME;

    @JSONField(name = "FIELD_COUPON_DISCOUNT")
    private BigDecimal FIELD_COUPON_DISCOUNT;

    /**
     * 此处时间
     */
    @DateTimeFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "FIELD_COUPON_VALID_DATE")
    private Date FIELD_COUPON_VALID_DATE;

    @JSONField(name = "FIELD_COUPON_EXPLAIN")
    private String FIELD_COUPON_EXPLAIN;

    @JSONField(name = "FIELD_TEXT")
    private String FIELD_TEXT;
}
