package com.bizvane.messagefacade.interfaces;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.messagefacade.models.vo.vg.WechatAppletSubscribeRequestVo;
import com.bizvane.messagefacade.models.vo.vg.WechatAppletSubscribeResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/wechatAppletSubscribeMsg")
public interface WechatAppletSubscirbeMsgServiceFeign {

    @PostMapping("subscribeMessageRequest")
    ResponseData<String> subscribeMessageRequest(@RequestBody JSONObject requestVO);

    @PostMapping("subscribeMsgPopupEvent")
    ResponseData<String> subscribeMsgPopupEvent(@RequestBody JSONObject requestVO);

    @PostMapping("subscribeMsgChangeEvent")
    ResponseData<String> subscribeMsgChangeEvent(@RequestBody JSONObject requestVO);

    @PostMapping("subscribeMsgSentEvent")
    ResponseData<String> subscribeMsgSentEvent(@RequestBody JSONObject requestVO);

}
