/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.listener.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.api.model.vo.subscribe.WxMiniSubscribeMessageTempVO;
import com.bizvane.message.api.model.vo.subscribe.WxMiniSubscribeMessageVO;
import com.bizvane.message.api.service.RocketMQBusinessService;
import com.bizvane.message.api.service.RocketMessageHandler;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.domain.enums.WeChatAppletSubscribeTopicEnum;
import com.bizvane.message.domain.enums.msg.MsgTemplateTypeEnum;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempScenePO;
import com.bizvane.message.domain.model.entity.MsgWxMiniSubscribeClickPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniSubscribeParamPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniSubscribeRecordPO;
import com.bizvane.message.domain.service.IMsgWxMiniProTempSceneService;
import com.bizvane.message.domain.service.IMsgWxMiniSubscribeClickService;
import com.bizvane.message.domain.service.IMsgWxMiniSubscribeParamService;
import com.bizvane.message.domain.service.IMsgWxMiniSubscribeRecordService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MsgWxMiniSubscribeMessageHandler
implements RocketMessageHandler<Object, WxMiniSubscribeMessageVO> {
    private final RocketMQBusinessService rocketMQBusinessService;
    private final IMsgWxMiniProTempSceneService msgWxMiniProTempSceneService;
    private final IMsgWxMiniSubscribeClickService msgWxMiniSubscribeClickService;
    private final IMsgWxMiniSubscribeParamService msgWxMiniSubscribeParamService;
    private final IMsgWxMiniSubscribeRecordService msgWxMiniSubscribeRecordService;

    @Override
    public ResponseData<SendResult> sendMQMessage(WxMiniSubscribeMessageVO wxMiniSubscribeMessageVO) {
        AssertUtil.notNull(wxMiniSubscribeMessageVO.getMsgWxMiniProTempSceneCode(), wxMiniSubscribeMessageVO.getOpenId(), wxMiniSubscribeMessageVO.getType(), wxMiniSubscribeMessageVO.getMemberCode(), wxMiniSubscribeMessageVO.getBusinessParam(), wxMiniSubscribeMessageVO.getSubscribeMessage());
        AssertUtil.notEmpty(wxMiniSubscribeMessageVO.getMsgWxMiniProTempList());
        JSONObject json = (JSONObject)JSON.toJSON((Object)wxMiniSubscribeMessageVO);
        SendResult sendResult = this.rocketMQBusinessService.sendWechatSubscribe(wxMiniSubscribeMessageVO, WeChatAppletSubscribeTopicEnum.REQUEST_SUBSCRIBE_MESSAGE);
        return ResponseUtil.success((Object)sendResult);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Object> handlerMQMessage(WxMiniSubscribeMessageVO wxMiniSubscribeMessageVO) {
        MsgWxMiniProTempScenePO proTempScenePO = this.msgWxMiniProTempSceneService.selectOneByCode(wxMiniSubscribeMessageVO.getMsgWxMiniProTempSceneCode());
        if (proTempScenePO == null) {
            return ResponseUtil.fail((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f\u573a\u666f\u4e0d\u5b58\u5728!");
        }
        MsgWxMiniSubscribeClickPO subscribeClickPOAdd = this.saveMsgWxMiniSubscribeClickPO(wxMiniSubscribeMessageVO);
        this.saveMsgWxMiniSubscribeParamAndRecord(wxMiniSubscribeMessageVO, subscribeClickPOAdd);
        return ResponseUtil.success();
    }

    private void saveMsgWxMiniSubscribeParamAndRecord(WxMiniSubscribeMessageVO wxMiniSubscribeMessageVO, MsgWxMiniSubscribeClickPO subscribeClickPOAdd) {
        if ("SUCCESS".equals(wxMiniSubscribeMessageVO.getType()) && CollectionUtils.isNotEmpty(wxMiniSubscribeMessageVO.getMsgWxMiniProTempList())) {
            JSONObject requestSubscribeSuccessMessage = JSON.parseObject((String)wxMiniSubscribeMessageVO.getSubscribeMessage());
            requestSubscribeSuccessMessage.remove((Object)"errMsg");
            Map subscribeMessageTempVOMap = wxMiniSubscribeMessageVO.getMsgWxMiniProTempList().stream().collect(Collectors.toMap(WxMiniSubscribeMessageTempVO::getWxTempId, Function.identity(), (a, b) -> a));
            for (String wxTempId : requestSubscribeSuccessMessage.keySet()) {
                String subscribeStatus = requestSubscribeSuccessMessage.getString(wxTempId);
                WxMiniSubscribeMessageTempVO wxMiniSubscribeMessageTempVO = (WxMiniSubscribeMessageTempVO)subscribeMessageTempVOMap.get(wxTempId);
                MsgWxMiniSubscribeParamPO subscribeParamPOAdd = this.saveMsgWxMiniSubscribeParamPO(subscribeClickPOAdd, subscribeStatus, wxMiniSubscribeMessageTempVO);
                MsgWxMiniSubscribeRecordPO msgWxMiniSubscribeRecordPO = this.saveMsgWxMiniSubscribeRecordPO(subscribeClickPOAdd, wxMiniSubscribeMessageTempVO, subscribeParamPOAdd);
            }
        }
    }

    private MsgWxMiniSubscribeRecordPO saveMsgWxMiniSubscribeRecordPO(MsgWxMiniSubscribeClickPO subscribeClickPOAdd, WxMiniSubscribeMessageTempVO wxMiniSubscribeMessageTempVO, MsgWxMiniSubscribeParamPO subscribeParamPOAdd) {
        String templateType = wxMiniSubscribeMessageTempVO.getTemplateType();
        MsgWxMiniSubscribeRecordPO subscribeRecordPOAdd = new MsgWxMiniSubscribeRecordPO();
        subscribeRecordPOAdd.setMsgWxMiniSubscribeRecordCode(UID.getUid());
        subscribeRecordPOAdd.setMsgWxMiniSubscribeParamCode(subscribeParamPOAdd.getMsgWxMiniSubscribeParamCode());
        subscribeRecordPOAdd.setMsgWxMiniProTempSceneCode(subscribeClickPOAdd.getMsgWxMiniProTempSceneCode());
        subscribeRecordPOAdd.setMemberCode(subscribeParamPOAdd.getMemberCode());
        subscribeRecordPOAdd.setFromUserName(subscribeParamPOAdd.getFromUserName());
        subscribeRecordPOAdd.setTemplateId(wxMiniSubscribeMessageTempVO.getWxTempId());
        subscribeRecordPOAdd.setTemplateType(templateType);
        subscribeRecordPOAdd.setSubscribeStatus(subscribeParamPOAdd.getSubscribeStatus());
        boolean recordSave = this.msgWxMiniSubscribeRecordService.save((Object)subscribeRecordPOAdd);
        return subscribeRecordPOAdd;
    }

    private MsgWxMiniSubscribeParamPO saveMsgWxMiniSubscribeParamPO(MsgWxMiniSubscribeClickPO subscribeClickPOAdd, String subscribeStatus, WxMiniSubscribeMessageTempVO wxMiniSubscribeMessageTempVO) {
        String templateType = wxMiniSubscribeMessageTempVO.getTemplateType();
        JSONObject businessParamJson = JSON.parseObject((String)subscribeClickPOAdd.getBusniessParam());
        MsgWxMiniSubscribeParamPO subscribeParamPOAdd = new MsgWxMiniSubscribeParamPO();
        subscribeParamPOAdd.setMsgWxMiniSubscribeParamCode(UID.getUid());
        subscribeParamPOAdd.setMsgWxMiniSubscribeClickCode(subscribeClickPOAdd.getMsgWxMiniSubscribeClickCode());
        subscribeParamPOAdd.setMsgWxMiniProTempCode(wxMiniSubscribeMessageTempVO.getMsgWxMiniProTempCode());
        subscribeParamPOAdd.setFromUserName(subscribeClickPOAdd.getWxOpenId());
        subscribeParamPOAdd.setSubscribeStatus(subscribeStatus);
        subscribeParamPOAdd.setMemberCode(subscribeClickPOAdd.getMemberCode());
        this.fillBusinessParam(businessParamJson, subscribeParamPOAdd, templateType);
        boolean paramSave = this.msgWxMiniSubscribeParamService.save((Object)subscribeParamPOAdd);
        return subscribeParamPOAdd;
    }

    private MsgWxMiniSubscribeClickPO saveMsgWxMiniSubscribeClickPO(WxMiniSubscribeMessageVO wxMiniSubscribeMessageVO) {
        MsgWxMiniSubscribeClickPO subscribeClickPOAdd = new MsgWxMiniSubscribeClickPO();
        subscribeClickPOAdd.setMsgWxMiniSubscribeClickCode(UID.getUid());
        subscribeClickPOAdd.setMsgWxMiniProTempSceneCode(wxMiniSubscribeMessageVO.getMsgWxMiniProTempSceneCode());
        subscribeClickPOAdd.setWxOpenId(wxMiniSubscribeMessageVO.getOpenId());
        subscribeClickPOAdd.setMemberCode(wxMiniSubscribeMessageVO.getMemberCode());
        subscribeClickPOAdd.setType(wxMiniSubscribeMessageVO.getType());
        subscribeClickPOAdd.setSubscribeMessage(wxMiniSubscribeMessageVO.getSubscribeMessage());
        subscribeClickPOAdd.setBusniessParam(wxMiniSubscribeMessageVO.getBusinessParam());
        subscribeClickPOAdd.setRemark(wxMiniSubscribeMessageVO.getRemark());
        boolean clickSave = this.msgWxMiniSubscribeClickService.save((Object)subscribeClickPOAdd);
        return subscribeClickPOAdd;
    }

    private void fillBusinessParam(JSONObject businessParamJson, MsgWxMiniSubscribeParamPO msgWxMiniSubscribeParamPO, String templateType) {
        if (businessParamJson.containsKey((Object)"couponCode") && MsgTemplateTypeEnum.isCoupon((String)templateType)) {
            msgWxMiniSubscribeParamPO.setCouponCode(businessParamJson.getString("couponCode"));
        }
        if (businessParamJson.containsKey((Object)"activityCode") && MsgTemplateTypeEnum.isActivity((String)templateType)) {
            msgWxMiniSubscribeParamPO.setActivityCode(businessParamJson.getString("activityCode"));
        }
        if (businessParamJson.containsKey((Object)"taskCode") && MsgTemplateTypeEnum.isTask((String)templateType)) {
            msgWxMiniSubscribeParamPO.setTaskCode(businessParamJson.getString("taskCode"));
        }
        if (businessParamJson.containsKey((Object)"activityCode") && MsgTemplateTypeEnum.isCoupon((String)templateType)) {
            msgWxMiniSubscribeParamPO.setActivityCode(businessParamJson.getString("activityCode"));
        }
    }

    public MsgWxMiniSubscribeMessageHandler(RocketMQBusinessService rocketMQBusinessService, IMsgWxMiniProTempSceneService msgWxMiniProTempSceneService, IMsgWxMiniSubscribeClickService msgWxMiniSubscribeClickService, IMsgWxMiniSubscribeParamService msgWxMiniSubscribeParamService, IMsgWxMiniSubscribeRecordService msgWxMiniSubscribeRecordService) {
        this.rocketMQBusinessService = rocketMQBusinessService;
        this.msgWxMiniProTempSceneService = msgWxMiniProTempSceneService;
        this.msgWxMiniSubscribeClickService = msgWxMiniSubscribeClickService;
        this.msgWxMiniSubscribeParamService = msgWxMiniSubscribeParamService;
        this.msgWxMiniSubscribeRecordService = msgWxMiniSubscribeRecordService;
    }
}

