/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.listener.handler;

import com.bizvane.message.api.model.vo.sms.MsgSmsSentBatchMembersVO;
import com.bizvane.message.api.model.vo.sms.mq.MsgSmsSentBatchMessageVO;
import com.bizvane.message.api.service.RocketMQBusinessService;
import com.bizvane.message.api.service.RocketMessageHandler;
import com.bizvane.message.domain.enums.msg.MsgSmsSendStateEnum;
import com.bizvane.message.domain.model.entity.MsgSmsSentBatchPO;
import com.bizvane.message.domain.model.entity.MsgSmsSentRecordPO;
import com.bizvane.message.domain.service.IMsgSmsSentRecordService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.producer.SendResult;
import org.springframework.stereotype.Component;

@Component
public class MsgSmsSentBatchMessageHandler
implements RocketMessageHandler<Object, MsgSmsSentBatchMessageVO> {
    private final RocketMQBusinessService rocketMQBusinessService;
    private final IMsgSmsSentRecordService msgSmsSentRecordService;

    @Override
    public ResponseData<SendResult> sendMQMessage(MsgSmsSentBatchMessageVO param) {
        SendResult sendResult = this.rocketMQBusinessService.sendSmsSentBatch(param);
        return ResponseUtil.success((Object)sendResult);
    }

    @Override
    public ResponseData<Object> handlerMQMessage(MsgSmsSentBatchMessageVO param) {
        MsgSmsSentBatchPO msgSmsSentBatchPO = param.getMsgSmsSentBatchPO();
        List<MsgSmsSentBatchMembersVO> memberList = param.getMemberList();
        List smsSentRecordPOS = memberList.stream().map(msgSmsSentBatchMembersVO -> {
            MsgSmsSentRecordPO msgSmsSentRecordPO = new MsgSmsSentRecordPO();
            msgSmsSentRecordPO.setMsgSmsSentRecordCode(UID.getUid());
            msgSmsSentRecordPO.setMsgSmsSentBatchCode(msgSmsSentBatchPO.getMsgSmsSentBatchCode());
            msgSmsSentRecordPO.setSmsTemplateName(msgSmsSentBatchPO.getSmsTemplateName());
            msgSmsSentRecordPO.setSmsTemplateCode(msgSmsSentBatchPO.getMsgSmsSentBatchCode());
            msgSmsSentRecordPO.setSmsTemplateType(msgSmsSentBatchPO.getSmsTemplateType());
            msgSmsSentRecordPO.setTemplateType(msgSmsSentBatchPO.getTemplateType());
            msgSmsSentRecordPO.setBusinessType(msgSmsSentRecordPO.getBusinessType());
            msgSmsSentRecordPO.setMemberCode(msgSmsSentBatchMembersVO.getMemberCode());
            msgSmsSentRecordPO.setMemberName(msgSmsSentBatchMembersVO.getMemberName());
            msgSmsSentRecordPO.setCardNo(msgSmsSentBatchMembersVO.getCardNo());
            msgSmsSentRecordPO.setPhone(msgSmsSentBatchMembersVO.getPhone());
            msgSmsSentRecordPO.setSendState(MsgSmsSendStateEnum.DEFAULT.getCode());
            return msgSmsSentRecordPO;
        }).collect(Collectors.toList());
        boolean saveBatch = this.msgSmsSentRecordService.saveBatch(smsSentRecordPOS);
        return ResponseUtil.success();
    }

    public MsgSmsSentBatchMessageHandler(RocketMQBusinessService rocketMQBusinessService, IMsgSmsSentRecordService msgSmsSentRecordService) {
        this.rocketMQBusinessService = rocketMQBusinessService;
        this.msgSmsSentRecordService = msgSmsSentRecordService;
    }
}

