/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.api.service.RocketMQBusinessService;
import com.bizvane.message.api.service.SubscribeSendService;
import com.bizvane.message.domain.enums.WeChatSubscribeTopicEnum;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.feign.vo.msg.MsgBodyResponseVO;
import com.bizvane.message.feign.vo.msg.MsgBodyWrapperVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeActivityBeginsBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeActivitySignBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeActivityWinningBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeCouponExpireBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeCouponReceiveBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeCouponUseBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeFlightBoardingBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeFlightDelayBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeFlightGateChangeBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeFlightLuggageChangeBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeFlightTravelBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeIntegralExpireBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeIntegralOrderSendBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeIntegralReceiveBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeIntegralUseBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeMassTaskBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeMemberRegistrationBodyVO;
import com.bizvane.message.feign.vo.msg.subscribe.SubscribeServiceEvaluationBodyVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.springframework.stereotype.Service;

@Service
public class SubscribeAsyncSendServiceImpl
implements SubscribeSendService {
    private final RocketMQBusinessService rocketMQBusinessService;

    @Override
    public ResponseData<MsgBodyResponseVO> flightTravel(MsgBodyWrapperVO<SubscribeFlightTravelBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.FLIGHT_TRAVEL);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> flightBoarding(MsgBodyWrapperVO<SubscribeFlightBoardingBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.FLIGHT_BOARDING);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> flightDelay(MsgBodyWrapperVO<SubscribeFlightDelayBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.FLIGHT_DELAY);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> flightGateChange(MsgBodyWrapperVO<SubscribeFlightGateChangeBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.FLIGHT_GATE_CHANGE);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> flightLuggageChange(MsgBodyWrapperVO<SubscribeFlightLuggageChangeBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.FLIGHT_LUGGAGE_CHANGE);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> serviceEvaluation(MsgBodyWrapperVO<SubscribeServiceEvaluationBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.SERVICE_EVALUATION);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> memberRegistration(MsgBodyWrapperVO<SubscribeMemberRegistrationBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.MEMBER_REGISTRATION);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> integralReceive(MsgBodyWrapperVO<SubscribeIntegralReceiveBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.INTEGRAL_RECEIVE);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> integralUse(MsgBodyWrapperVO<SubscribeIntegralUseBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.INTEGRAL_USE);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> integralExpire(MsgBodyWrapperVO<SubscribeIntegralExpireBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.INTEGRAL_EXPIRE);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> couponReceive(MsgBodyWrapperVO<SubscribeCouponReceiveBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.COUPON_RECEIVE);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> couponUse(MsgBodyWrapperVO<SubscribeCouponUseBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.COUPON_USE);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> couponExpire(MsgBodyWrapperVO<SubscribeCouponExpireBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.COUPON_EXPIRE);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> activityWinning(MsgBodyWrapperVO<SubscribeActivityWinningBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.ACTIVITY_WINNING);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> activitySign(MsgBodyWrapperVO<SubscribeActivitySignBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.ACTIVITY_SIGN);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> activityBegins(MsgBodyWrapperVO<SubscribeActivityBeginsBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.ACTIVITY_BEGINS);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> integralOrderSend(MsgBodyWrapperVO<SubscribeIntegralOrderSendBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.INTEGRAL_ORDER_SEND);
    }

    @Override
    public ResponseData<MsgBodyResponseVO> massTask(MsgBodyWrapperVO<SubscribeMassTaskBodyVO> subscribeWrapperVO) {
        return this.execute(subscribeWrapperVO, WeChatSubscribeTopicEnum.MKT_MASS_MESSAGE);
    }

    private ResponseData<MsgBodyResponseVO> execute(MsgBodyWrapperVO subscribeWrapperVO, WeChatSubscribeTopicEnum weChatSubscribeTopicEnum) {
        SendResult sendResult = this.rocketMQBusinessService.sendWechatSubscribeAsyncSend(JSONObject.toJSONString((Object)subscribeWrapperVO), weChatSubscribeTopicEnum);
        MsgBodyResponseVO msgBodyResponseVO = new MsgBodyResponseVO();
        if (sendResult.getSendStatus() != SendStatus.SEND_OK) {
            return ResponseUtil.fail((String)sendResult.getSendStatus().name());
        }
        msgBodyResponseVO.setMsgId(sendResult.getMsgId());
        return ResponseUtil.success((Object)msgBodyResponseVO);
    }

    public SubscribeAsyncSendServiceImpl(RocketMQBusinessService rocketMQBusinessService) {
        this.rocketMQBusinessService = rocketMQBusinessService;
    }
}

