/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.message.api.model.dto.config.OptUserDTO;
import com.bizvane.message.api.model.dto.template.wxsubscribe.WeChatMiniProTempEditStatusRequestParam;
import com.bizvane.message.api.model.dto.template.wxsubscribe.WeChatMiniProTempListRequestParam;
import com.bizvane.message.api.model.dto.template.wxsubscribe.WeChatMiniProTempListResponseVO;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWxMiniProTempFieldVO;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWxMiniProTempPlaceholderRequestVO;
import com.bizvane.message.api.model.vo.template.wxmini.MsgWxMiniProTempPlaceholderResponseVO;
import com.bizvane.message.api.model.vo.template.wxmini.WeChatMiniProTempDetailEditRequestVO;
import com.bizvane.message.api.model.vo.template.wxmini.WeChatMiniProTempDetailFieldEditRequestVO;
import com.bizvane.message.api.model.vo.template.wxmini.WeChatMiniProTempDetailRequestVO;
import com.bizvane.message.api.model.vo.template.wxmini.WeChatMiniProTempDetailResponseVO;
import com.bizvane.message.api.service.MsgWeChatMiniProTemplateService;
import com.bizvane.message.api.service.OptUserService;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.api.util.ConvertUtil;
import com.bizvane.message.domain.enums.msg.MsgTemplateTypeMap;
import com.bizvane.message.domain.model.bo.MsgWxMiniProTempBO;
import com.bizvane.message.domain.model.bo.MsgWxMiniProTempFieldBO;
import com.bizvane.message.domain.model.bo.WeChatMiniProTempEditBO;
import com.bizvane.message.domain.model.bo.WeChatMiniProTempQueryBO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempFieldPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempPlaceholderRelPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempTemplateTypePO;
import com.bizvane.message.domain.service.IMsgWxMiniProTempFieldService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempPlaceholderRelService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempPlaceholderService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempService;
import com.bizvane.message.domain.service.IMsgWxMiniProTempTemplateTypeService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.message.feign.vo.OptUserVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempDetailResponseVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempPlaceholderRelDetailRequestVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempPlaceholderRelDetailResponseVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempUpdateRequestVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempUpdateResponseVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempUpdateStatusRequestVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempUpdateStatusResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MsgWeChatMiniProTemplateServiceImpl
implements MsgWeChatMiniProTemplateService {
    private final StringRedisTemplate redisTemplate;
    private final IMsgWxMiniProTempService msgWxMiniProTempService;
    private final OptUserService optUserService;
    private final IMsgWxMiniProTempFieldService msgWxMiniProTempFieldService;
    private final IMsgWxMiniProTempPlaceholderService msgWxMiniProTempPlaceholderService;
    private final IMsgWxMiniProTempTemplateTypeService msgWxMiniProTempTemplateTypeService;
    private final IMsgWxMiniProTempPlaceholderRelService msgWxMiniProTempPlaceholderRelService;

    @Override
    public ResponseData<List<WeChatMiniProTempListResponseVO>> getWeChatMiniProTemplateFromWechat(WeChatMiniProTempListRequestParam requestParam) {
        String uid = "example";
        String list = (String)this.redisTemplate.opsForValue().get((Object)("WXMiniProTemp_" + uid));
        if (StringUtils.isNotBlank((CharSequence)list)) {
            List resultList = JSON.parseArray((String)list, WeChatMiniProTempListResponseVO.class);
            return new ResponseData((Object)resultList);
        }
        String weChatMiniProAccessToken = null;
        List<WeChatMiniProTempListResponseVO> weChatMiniProTemplateData = this.getWeChatMiniProTemplateData(weChatMiniProAccessToken);
        this.redisTemplate.opsForValue().set((Object)("WXMiniProTemp_" + uid), (Object)JSON.toJSONString(weChatMiniProTemplateData), 60L, TimeUnit.MINUTES);
        return new ResponseData(weChatMiniProTemplateData);
    }

    @Override
    public ResponseData<Boolean> updateSceneOpenJudge(WeChatMiniProTempEditStatusRequestParam requestParam) {
        AssertUtil.notNull((Object)requestParam.getOpenJudge(), requestParam.getMsgWxMiniProTempCode());
        OptUserDTO optUser = this.optUserService.getOptUser();
        WeChatMiniProTempEditBO weChatMiniProTempEditBO = new WeChatMiniProTempEditBO();
        weChatMiniProTempEditBO.setOpenJudge(requestParam.getOpenJudge());
        weChatMiniProTempEditBO.setMsgWxMiniProTempCode(requestParam.getMsgWxMiniProTempCode());
        weChatMiniProTempEditBO.setOptUserCode(optUser.getOptUserCode());
        weChatMiniProTempEditBO.setOptUserName(optUser.getOptUserName());
        Boolean result = this.msgWxMiniProTempService.updateBrandSceneOpenJudge(weChatMiniProTempEditBO);
        return new ResponseData((Object)result);
    }

    @Override
    public ResponseData<List<MsgWxMiniProTempPlaceholderResponseVO>> findPlaceHolderByTemplateType(MsgWxMiniProTempPlaceholderRequestVO requestParam) {
        AssertUtil.notNull(requestParam.getTemplateType());
        MsgWxMiniProTempTemplateTypePO miniProTempTemplateTypePO = this.msgWxMiniProTempTemplateTypeService.findByWxMiniProTempTemplateType(requestParam.getTemplateType());
        return this.getMsgWxMiniProTempPlaceholderList(miniProTempTemplateTypePO);
    }

    @Override
    public ResponseData<List<MsgWxMiniProTempPlaceholderRelDetailResponseVO>> listPlaceholderRel(MsgWxMiniProTempPlaceholderRelDetailRequestVO requestVO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgWxMiniProTempPlaceholderRelPO::getTemplateType, (Object)requestVO.getTemplateType());
        List poList = this.msgWxMiniProTempPlaceholderRelService.list((Wrapper)queryWrapper);
        ArrayList<MsgWxMiniProTempPlaceholderRelDetailResponseVO> resultList = new ArrayList<MsgWxMiniProTempPlaceholderRelDetailResponseVO>();
        if (CollectionUtils.isNotEmpty((Collection)poList)) {
            for (MsgWxMiniProTempPlaceholderRelPO msgWxMiniProTempPlaceholderRelPO : poList) {
                MsgWxMiniProTempPlaceholderRelDetailResponseVO msgWxMiniProTempPlaceholderRelDetailResponseVO = ConvertUtil.convertMsgWxMiniProTempPlaceholderRelPO2VO(msgWxMiniProTempPlaceholderRelPO);
                resultList.add(msgWxMiniProTempPlaceholderRelDetailResponseVO);
            }
        }
        return ResponseUtil.success(resultList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResponseData<MsgWxMiniProTempUpdateResponseVO> addOrUpdateTemplate(MsgWxMiniProTempUpdateRequestVO requestVO) {
        MsgWxMiniProTempPO msgWxMiniProTempPO = this.msgWxMiniProTempService.selectOneByTemplateType(requestVO.getTemplateType());
        if (msgWxMiniProTempPO == null) {
            return this.addTemplate(requestVO);
        }
        return this.updateTemplate(requestVO, msgWxMiniProTempPO);
    }

    private ResponseData updateTemplate(MsgWxMiniProTempUpdateRequestVO requestVO, MsgWxMiniProTempPO msgWxMiniProTempPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(MsgWxMiniProTempPO::getWxTempId, (Object)requestVO.getWxTempId())).set(MsgWxMiniProTempPO::getWxTempTitle, (Object)requestVO.getWxTempTitle())).set(MsgWxMiniProTempPO::getWxTempText, (Object)requestVO.getWxTempText())).set(MsgWxMiniProTempPO::getWxTempType, (Object)requestVO.getWxTempType())).set(MsgWxMiniProTempPO::getUrl, (Object)requestVO.getUrl())).set(MsgWxMiniProTempPO::getOpenStatus, (Object)requestVO.getOpenStatus())).set(MsgWxMiniProTempPO::getRemark, (Object)requestVO.getRemark())).set(MsgWxMiniProTempPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(MsgWxMiniProTempPO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(MsgWxMiniProTempPO::getMsgWxMiniProTempCode, (Object)msgWxMiniProTempPO.getMsgWxMiniProTempCode());
        boolean update = this.msgWxMiniProTempService.update((Wrapper)updateWrapper);
        if (update) {
            String msgWxMiniProTempCode = requestVO.getMsgWxMiniProTempCode();
            boolean delete = this.msgWxMiniProTempFieldService.deleteWithOptUserByMsgWxMiniProTempCodeAnd(msgWxMiniProTempCode, (OptUserVO)requestVO);
            this.addTemplateField(requestVO, msgWxMiniProTempCode);
        }
        MsgWxMiniProTempUpdateResponseVO responseVO = new MsgWxMiniProTempUpdateResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    private ResponseData addTemplate(MsgWxMiniProTempUpdateRequestVO requestVO) {
        MsgWxMiniProTempPO msgWxMiniProTempPO = new MsgWxMiniProTempPO();
        msgWxMiniProTempPO.setMsgWxMiniProTempCode(UID.getUid());
        msgWxMiniProTempPO.setWxTempId(requestVO.getWxTempId());
        msgWxMiniProTempPO.setWxTempTitle(requestVO.getWxTempTitle());
        msgWxMiniProTempPO.setWxTempText(requestVO.getWxTempText());
        msgWxMiniProTempPO.setWxTempType(requestVO.getWxTempType());
        msgWxMiniProTempPO.setUrl(requestVO.getUrl());
        msgWxMiniProTempPO.setOpenStatus(requestVO.getOpenStatus());
        msgWxMiniProTempPO.setTemplateType(requestVO.getTemplateType());
        msgWxMiniProTempPO.setBusinessType(MsgTemplateTypeMap.getKey((Object)requestVO.getTemplateType()).getBusinessTypeEnum().getCode());
        msgWxMiniProTempPO.setRemark(requestVO.getRemark());
        msgWxMiniProTempPO.setCreateUserName(requestVO.getOptUserName());
        msgWxMiniProTempPO.setCreateUserCode(requestVO.getOptUserCode());
        boolean save = this.msgWxMiniProTempService.save((Object)msgWxMiniProTempPO);
        String msgWxMiniProTempCode = msgWxMiniProTempPO.getMsgWxMiniProTempCode();
        this.addTemplateField(requestVO, msgWxMiniProTempCode);
        MsgWxMiniProTempUpdateResponseVO msgWxMiniProTempUpdateResponseVO = new MsgWxMiniProTempUpdateResponseVO();
        msgWxMiniProTempUpdateResponseVO.setOptStatus(save);
        return ResponseUtil.success((Object)save);
    }

    private void addTemplateField(MsgWxMiniProTempUpdateRequestVO requestVO, String msgWxMiniProTempCode) {
        List fieldAddPOList = requestVO.getFieldList().stream().map(msgWxMiniProTempFieldUpdateRequestVO -> {
            MsgWxMiniProTempFieldPO msgWxMiniProTempFieldPO = new MsgWxMiniProTempFieldPO();
            msgWxMiniProTempFieldPO.setMsgWxMiniProTempFieldCode(UID.getUid());
            msgWxMiniProTempFieldPO.setMsgWxMiniProTempCode(msgWxMiniProTempCode);
            msgWxMiniProTempFieldPO.setFieldName(msgWxMiniProTempFieldUpdateRequestVO.getFieldName());
            msgWxMiniProTempFieldPO.setFieldType(msgWxMiniProTempFieldUpdateRequestVO.getFieldType());
            msgWxMiniProTempFieldPO.setLocalFieldName(msgWxMiniProTempFieldUpdateRequestVO.getLocalFieldName());
            msgWxMiniProTempFieldPO.setLocalFieldType(msgWxMiniProTempFieldUpdateRequestVO.getLocalFieldType());
            msgWxMiniProTempFieldPO.setLocalFieldValue(msgWxMiniProTempFieldUpdateRequestVO.getLocalFieldValue());
            msgWxMiniProTempFieldPO.setJsonFieldName(msgWxMiniProTempFieldUpdateRequestVO.getJsonFieldName());
            msgWxMiniProTempFieldPO.setNullable(msgWxMiniProTempFieldUpdateRequestVO.getNullable());
            msgWxMiniProTempFieldPO.setRemark(msgWxMiniProTempFieldUpdateRequestVO.getRemark());
            msgWxMiniProTempFieldPO.setCreateUserName(requestVO.getOptUserName());
            msgWxMiniProTempFieldPO.setCreateUserCode(requestVO.getOptUserCode());
            return msgWxMiniProTempFieldPO;
        }).collect(Collectors.toList());
        boolean saveBatch = this.msgWxMiniProTempFieldService.saveBatch(fieldAddPOList);
    }

    @Override
    public ResponseData<WeChatMiniProTempDetailResponseVO> getSingleTemplate(WeChatMiniProTempDetailRequestVO requestVO) {
        AssertUtil.notNull(requestVO.getTemplateType());
        AssertUtil.judge(MsgTemplateTypeMap.containsKey((Object)requestVO.getTemplateType()), "templateType\u4e0d\u5b58\u5728");
        String businessType = MsgTemplateTypeMap.getKey((Object)requestVO.getTemplateType()).getBusinessTypeEnum().getCode();
        WeChatMiniProTempQueryBO weChatMiniProTempQueryBO = new WeChatMiniProTempQueryBO();
        weChatMiniProTempQueryBO.setTemplateType(requestVO.getTemplateType());
        weChatMiniProTempQueryBO.setBusinessType(businessType);
        MsgWxMiniProTempPO msgWxMiniProTempPO = this.msgWxMiniProTempService.selectOne(weChatMiniProTempQueryBO);
        if (msgWxMiniProTempPO == null) {
            return ResponseUtil.success((Object)new WeChatMiniProTempDetailResponseVO());
        }
        WeChatMiniProTempDetailResponseVO weChatMiniProTempDetailResponseVO = new WeChatMiniProTempDetailResponseVO();
        BeanUtils.copyProperties((Object)msgWxMiniProTempPO, (Object)weChatMiniProTempDetailResponseVO);
        List msgWxMiniProTempFieldPOS = this.msgWxMiniProTempFieldService.selectListByMsgWxMiniProTempCode(msgWxMiniProTempPO.getMsgWxMiniProTempCode());
        if (CollectionUtils.isNotEmpty((Collection)msgWxMiniProTempFieldPOS)) {
            List<MsgWxMiniProTempFieldVO> msgWxMiniProTempFieldVOS = msgWxMiniProTempFieldPOS.stream().map(msgWxMiniProTempFieldPO -> {
                MsgWxMiniProTempFieldVO msgWxMiniProTempFieldVO = new MsgWxMiniProTempFieldVO();
                BeanUtils.copyProperties((Object)msgWxMiniProTempFieldPO, (Object)msgWxMiniProTempFieldVO);
                return msgWxMiniProTempFieldVO;
            }).collect(Collectors.toList());
            weChatMiniProTempDetailResponseVO.setFieldList(msgWxMiniProTempFieldVOS);
        }
        return new ResponseData((Object)weChatMiniProTempDetailResponseVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Boolean> saveOrUpdateTemplate(WeChatMiniProTempDetailEditRequestVO requestVO) {
        AssertUtil.notEmpty(requestVO.getFieldList());
        AssertUtil.notNull(requestVO.getWxTempId(), requestVO.getWxTempTitle(), requestVO.getWxTempType(), requestVO.getTemplateType());
        AssertUtil.judge(MsgTemplateTypeMap.containsKey((Object)requestVO.getTemplateType()), "templateType\u4e0d\u5b58\u5728");
        String businessType = MsgTemplateTypeMap.getKey((Object)requestVO.getTemplateType()).getBusinessTypeEnum().getCode();
        requestVO.setBusinessType(businessType);
        WeChatMiniProTempQueryBO weChatMiniProTempQueryBO = new WeChatMiniProTempQueryBO();
        weChatMiniProTempQueryBO.setTemplateType(requestVO.getTemplateType());
        weChatMiniProTempQueryBO.setBusinessType(businessType);
        OptUserDTO optUser = this.optUserService.getOptUser();
        MsgWxMiniProTempPO msgWxMiniProTempPO = this.msgWxMiniProTempService.selectOne(weChatMiniProTempQueryBO);
        if (msgWxMiniProTempPO != null) {
            requestVO.setMsgWxMiniProTempCode(msgWxMiniProTempPO.getMsgWxMiniProTempCode());
            this.deleteOldTemplate(requestVO, optUser);
        }
        Boolean result = this.addTemplate(requestVO, optUser);
        return new ResponseData((Object)result);
    }

    @Override
    public ResponseData<MsgWxMiniProTempUpdateStatusResponseVO> updateStatus(MsgWxMiniProTempUpdateStatusRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(MsgWxMiniProTempPO::getOpenStatus, (Object)requestVO.getOpenStatus())).set(MsgWxMiniProTempPO::getCreateUserName, (Object)requestVO.getOptUserName())).set(MsgWxMiniProTempPO::getCreateUserCode, (Object)requestVO.getOptUserCode())).eq(MsgWxMiniProTempPO::getMsgWxMiniProTempCode, (Object)requestVO.getMsgWxMiniProTempCode());
        boolean update = this.msgWxMiniProTempService.update((Wrapper)updateWrapper);
        MsgWxMiniProTempUpdateStatusResponseVO responseVO = new MsgWxMiniProTempUpdateStatusResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    @Override
    public ResponseData<MsgWxMiniProTempDetailResponseVO> detailByCode(String msgWxMiniProTempCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgWxMiniProTempPO::getMsgWxMiniProTempCode, (Object)msgWxMiniProTempCode)).last("limit 1");
        MsgWxMiniProTempPO miniProTempPO = (MsgWxMiniProTempPO)this.msgWxMiniProTempService.getOne((Wrapper)queryWrapper);
        MsgWxMiniProTempDetailResponseVO responseVO = ConvertUtil.convertMsgWxMiniProTempPO2VO(miniProTempPO);
        if (miniProTempPO != null) {
            List msgWxMiniProTempFieldPOS = this.msgWxMiniProTempFieldService.selectListByMsgWxMiniProTempCode(msgWxMiniProTempCode);
            List fieldVOList = msgWxMiniProTempFieldPOS.stream().map(msgWxMiniProTempFieldPO -> ConvertUtil.convertMsgWxMiniProTempFieldPO2VO(msgWxMiniProTempFieldPO)).collect(Collectors.toList());
            responseVO.setFieldVOList(fieldVOList);
        }
        return ResponseUtil.success((Object)responseVO);
    }

    @Override
    public ResponseData<MsgWxMiniProTempDetailResponseVO> detailByTemplateType(String templateType) {
        MsgWxMiniProTempPO miniProTempPO = this.msgWxMiniProTempService.selectOneByTemplateType(templateType);
        MsgWxMiniProTempDetailResponseVO responseVO = ConvertUtil.convertMsgWxMiniProTempPO2VO(miniProTempPO);
        if (miniProTempPO != null) {
            String msgWxMiniProTempCode = miniProTempPO.getMsgWxMiniProTempCode();
            List msgWxMiniProTempFieldPOS = this.msgWxMiniProTempFieldService.selectListByMsgWxMiniProTempCode(msgWxMiniProTempCode);
            List fieldVOList = msgWxMiniProTempFieldPOS.stream().map(msgWxMiniProTempFieldPO -> ConvertUtil.convertMsgWxMiniProTempFieldPO2VO(msgWxMiniProTempFieldPO)).collect(Collectors.toList());
            responseVO.setFieldVOList(fieldVOList);
        }
        return ResponseUtil.success((Object)responseVO);
    }

    private void deleteOldTemplate(WeChatMiniProTempDetailEditRequestVO requestVO, OptUserDTO optUser) {
        WeChatMiniProTempEditBO weChatMiniProTempEditBO = new WeChatMiniProTempEditBO();
        weChatMiniProTempEditBO.setOptUserName(optUser.getOptUserName());
        weChatMiniProTempEditBO.setOptUserCode(optUser.getOptUserCode());
        weChatMiniProTempEditBO.setMsgWxMiniProTempCode(requestVO.getMsgWxMiniProTempCode());
        this.msgWxMiniProTempService.deleteMsgWxMiniProTemp(weChatMiniProTempEditBO);
        this.msgWxMiniProTempFieldService.deleteByMsgWxMiniProTempCode(weChatMiniProTempEditBO);
    }

    private Boolean addTemplate(WeChatMiniProTempDetailEditRequestVO requestVO, OptUserDTO optUser) {
        MsgWxMiniProTempBO msgWxMiniProTempBO = new MsgWxMiniProTempBO();
        BeanUtils.copyProperties((Object)requestVO, (Object)msgWxMiniProTempBO);
        msgWxMiniProTempBO.setCreateUserCode(optUser.getOptUserCode());
        msgWxMiniProTempBO.setCreateUserName(optUser.getOptUserName());
        msgWxMiniProTempBO.setMsgWxMiniProTempCode(UID.getUid());
        Boolean resultA = this.msgWxMiniProTempService.addMsgWxMiniProTemp(msgWxMiniProTempBO);
        List fieldBOList = requestVO.getFieldList().stream().map(msgWxMiniProTempFieldVO -> {
            MsgWxMiniProTempFieldBO msgWxMiniProTempFieldBO = new MsgWxMiniProTempFieldBO();
            BeanUtils.copyProperties((Object)msgWxMiniProTempFieldVO, (Object)msgWxMiniProTempFieldBO);
            msgWxMiniProTempFieldBO.setCreateUserCode(msgWxMiniProTempBO.getCreateUserCode());
            msgWxMiniProTempFieldBO.setCreateUserName(msgWxMiniProTempBO.getCreateUserName());
            msgWxMiniProTempFieldBO.setCreateDate(LocalDateTime.now());
            msgWxMiniProTempFieldBO.setMsgWxMiniProTempCode(msgWxMiniProTempBO.getMsgWxMiniProTempCode());
            msgWxMiniProTempFieldBO.setMsgWxMiniProTempFieldCode(UID.getUid());
            return msgWxMiniProTempFieldBO;
        }).collect(Collectors.toList());
        Boolean resultB = this.msgWxMiniProTempFieldService.addBath(fieldBOList);
        return resultA != false && resultB != false;
    }

    private void checkFieldList(WeChatMiniProTempDetailEditRequestVO requestVO) {
        List<WeChatMiniProTempDetailFieldEditRequestVO> fieldList = requestVO.getFieldList();
        AssertUtil.notEmpty(fieldList);
    }

    private List<WeChatMiniProTempListResponseVO> getWeChatMiniProTemplateData(String accessToken) {
        return null;
    }

    private ResponseData<List<MsgWxMiniProTempPlaceholderResponseVO>> getMsgWxMiniProTempPlaceholderList(MsgWxMiniProTempTemplateTypePO miniProTempTemplateTypePO) {
        if (miniProTempTemplateTypePO != null) {
            List msgWxMiniProTempPlaceholderPOS = this.msgWxMiniProTempPlaceholderService.selectPlaceHolderByTemplateType(miniProTempTemplateTypePO.getTemplateType());
            List resultList = msgWxMiniProTempPlaceholderPOS.stream().map(msgWxMiniProTempPlaceholderBO -> {
                MsgWxMiniProTempPlaceholderResponseVO msgWxMiniProTempPlaceholderResponseVO = new MsgWxMiniProTempPlaceholderResponseVO();
                BeanUtils.copyProperties((Object)msgWxMiniProTempPlaceholderBO, (Object)msgWxMiniProTempPlaceholderResponseVO);
                return msgWxMiniProTempPlaceholderResponseVO;
            }).collect(Collectors.toList());
            return ResponseUtil.success(resultList);
        }
        return ResponseUtil.success(new ArrayList());
    }

    public MsgWeChatMiniProTemplateServiceImpl(StringRedisTemplate redisTemplate, IMsgWxMiniProTempService msgWxMiniProTempService, OptUserService optUserService, IMsgWxMiniProTempFieldService msgWxMiniProTempFieldService, IMsgWxMiniProTempPlaceholderService msgWxMiniProTempPlaceholderService, IMsgWxMiniProTempTemplateTypeService msgWxMiniProTempTemplateTypeService, IMsgWxMiniProTempPlaceholderRelService msgWxMiniProTempPlaceholderRelService) {
        this.redisTemplate = redisTemplate;
        this.msgWxMiniProTempService = msgWxMiniProTempService;
        this.optUserService = optUserService;
        this.msgWxMiniProTempFieldService = msgWxMiniProTempFieldService;
        this.msgWxMiniProTempPlaceholderService = msgWxMiniProTempPlaceholderService;
        this.msgWxMiniProTempTemplateTypeService = msgWxMiniProTempTemplateTypeService;
        this.msgWxMiniProTempPlaceholderRelService = msgWxMiniProTempPlaceholderRelService;
    }
}

