/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.bizvane.message.api.model.dto.config.OptUserDTO;
import com.bizvane.message.api.model.vo.sms.MsgSmsSentBatchRequestVO;
import com.bizvane.message.api.model.vo.sms.MsgSmsSentBatchResponseVO;
import com.bizvane.message.api.model.vo.sms.mq.MsgSmsSentBatchMessageVO;
import com.bizvane.message.api.service.MsgSmsSentService;
import com.bizvane.message.api.service.OptUserService;
import com.bizvane.message.api.service.RocketMQBusinessService;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.domain.enums.SmsTemplateTypeEnum;
import com.bizvane.message.domain.enums.msg.MsgTemplateTypeEnum;
import com.bizvane.message.domain.model.entity.MsgSmsSentBatchPO;
import com.bizvane.message.domain.service.IMsgSmsSentBatchService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.springframework.stereotype.Service;

@Service
public class MsgSmsSentServiceImpl
implements MsgSmsSentService {
    private final IMsgSmsSentBatchService msgSmsSentBatchService;
    private final OptUserService optUserService;
    private final RocketMQBusinessService rocketMQBusinessService;

    @Override
    public ResponseData<MsgSmsSentBatchResponseVO> saveBatch(MsgSmsSentBatchRequestVO msgSmsSentBatchRequestVO) {
        this.saveBatchParamCheck(msgSmsSentBatchRequestVO);
        MsgSmsSentBatchPO andSaveMsgSmsSentBatch = this.getAndSaveMsgSmsSentBatch(msgSmsSentBatchRequestVO);
        ResponseData<MsgSmsSentBatchResponseVO> responseData = this.saveBatchSendMq(msgSmsSentBatchRequestVO, andSaveMsgSmsSentBatch);
        return responseData;
    }

    private ResponseData<MsgSmsSentBatchResponseVO> saveBatchSendMq(MsgSmsSentBatchRequestVO msgSmsSentBatchRequestVO, MsgSmsSentBatchPO andSaveMsgSmsSentBatch) {
        MsgSmsSentBatchMessageVO smsSentBatchMessageVO = new MsgSmsSentBatchMessageVO();
        smsSentBatchMessageVO.setMsgSmsSentBatchPO(andSaveMsgSmsSentBatch);
        smsSentBatchMessageVO.setMemberList(msgSmsSentBatchRequestVO.getMemberList());
        SendResult sendResult = this.rocketMQBusinessService.sendSmsSentBatch(smsSentBatchMessageVO);
        MsgSmsSentBatchResponseVO msgSmsSentBatchMessageVO = new MsgSmsSentBatchResponseVO();
        msgSmsSentBatchMessageVO.setMsgSmsSentBatchCode(andSaveMsgSmsSentBatch.getMsgSmsSentBatchCode());
        msgSmsSentBatchMessageVO.setSendResult(sendResult);
        return ResponseUtil.success((Object)msgSmsSentBatchMessageVO);
    }

    private MsgSmsSentBatchPO getAndSaveMsgSmsSentBatch(MsgSmsSentBatchRequestVO msgSmsSentBatchRequestVO) {
        OptUserDTO optUser = this.optUserService.getOptUser();
        MsgSmsSentBatchPO msgSmsSentBatchPO = new MsgSmsSentBatchPO();
        msgSmsSentBatchPO.setMsgSmsSentBatchCode(UID.getUid());
        msgSmsSentBatchPO.setMktMassTaskNo(msgSmsSentBatchRequestVO.getMktMassTaskNo());
        msgSmsSentBatchPO.setMktMassTaskCode(msgSmsSentBatchRequestVO.getMktMassTaskCode());
        msgSmsSentBatchPO.setTemplateType(msgSmsSentBatchRequestVO.getTemplateType());
        msgSmsSentBatchPO.setBusinessType(msgSmsSentBatchRequestVO.getBusinessType());
        msgSmsSentBatchPO.setSmsTemplateCode(msgSmsSentBatchRequestVO.getSmsTemplateCode());
        msgSmsSentBatchPO.setSmsTemplateName(msgSmsSentBatchRequestVO.getSmsTemplateName());
        msgSmsSentBatchPO.setSmsTemplateType(Integer.valueOf(msgSmsSentBatchRequestVO.getSmsTemplateType()));
        msgSmsSentBatchPO.setTotal(Integer.valueOf(msgSmsSentBatchRequestVO.getMemberList().size()));
        msgSmsSentBatchPO.setCreateUserCode(optUser.getOptUserCode());
        msgSmsSentBatchPO.setCreateUserName(optUser.getOptUserName());
        this.msgSmsSentBatchService.save((Object)msgSmsSentBatchPO);
        return msgSmsSentBatchPO;
    }

    private void saveBatchParamCheck(MsgSmsSentBatchRequestVO msgSmsSentBatchRequestVO) {
        AssertUtil.judge(ObjectUtils.allNotNull((Object[])new Object[]{msgSmsSentBatchRequestVO.getTemplateType(), msgSmsSentBatchRequestVO.getBusinessType()}), "\u6a21\u677f\u7c7b\u578b,\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notEmpty(msgSmsSentBatchRequestVO.getMemberList(), "\u4f1a\u5458code\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge(ObjectUtils.allNotNull((Object[])new Object[]{msgSmsSentBatchRequestVO.getSmsTemplateCode(), msgSmsSentBatchRequestVO.getSmsTemplateName(), msgSmsSentBatchRequestVO.getSmsTemplateType()}), "\u77ed\u4fe1\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        MsgTemplateTypeEnum templateTypeEnum = MsgTemplateTypeEnum.getByCode((String)msgSmsSentBatchRequestVO.getTemplateType());
        AssertUtil.notNull((Object)templateTypeEnum, "\u6a21\u677f\u7c7b\u578b\u4e0d\u5b58\u5728");
        AssertUtil.judge(templateTypeEnum.getBusinessTypeEnum().getCode().equals(msgSmsSentBatchRequestVO.getBusinessType()), "\u6a21\u677f\u7c7b\u578b\u548c\u4e1a\u52a1\u7c7b\u578b\u4f20\u5165\u6709\u8bef");
        AssertUtil.notNull(SmsTemplateTypeEnum.getCode((String)msgSmsSentBatchRequestVO.getSmsTemplateType()), "\u77ed\u4fe1\u6a21\u677f\u7c7b\u578b\u4e0d\u5b58\u5728");
        if (templateTypeEnum == MsgTemplateTypeEnum.MKT_MASS_MESSAGE) {
            AssertUtil.judge(ObjectUtils.anyNotNull((Object[])new Object[]{msgSmsSentBatchRequestVO.getMktMassTaskCode(), msgSmsSentBatchRequestVO.getMktMassTaskNo()}), "\u7fa4\u53d1\u6d88\u606f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public MsgSmsSentServiceImpl(IMsgSmsSentBatchService msgSmsSentBatchService, OptUserService optUserService, RocketMQBusinessService rocketMQBusinessService) {
        this.msgSmsSentBatchService = msgSmsSentBatchService;
        this.optUserService = optUserService;
        this.rocketMQBusinessService = rocketMQBusinessService;
    }
}

