/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.bizvane.message.api.model.dto.config.OptUserDTO;
import com.bizvane.message.api.model.vo.template.sms.MsgSmsDefTempSaveRequestParam;
import com.bizvane.message.api.model.vo.template.sms.MsgSmsDefTempVO;
import com.bizvane.message.api.service.MsgSmsDefTempService;
import com.bizvane.message.api.service.OptUserService;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.domain.model.entity.MsgSmsDefTempPO;
import com.bizvane.message.domain.service.IMsgSmsDefTempService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class MsgSmsDefTempWrapperServiceImpl
implements MsgSmsDefTempService {
    private final IMsgSmsDefTempService msgSmsDefTempService;
    private final OptUserService optUserService;

    @Override
    public ResponseData<MsgSmsDefTempVO> getSmsDefTemp() {
        MsgSmsDefTempPO msgSmsDefTempPO = this.msgSmsDefTempService.selectOne();
        if (msgSmsDefTempPO == null) {
            return ResponseUtil.success((Object)new MsgSmsDefTempVO());
        }
        MsgSmsDefTempVO msgSmsDefTempVO = new MsgSmsDefTempVO();
        BeanUtils.copyProperties((Object)msgSmsDefTempPO, (Object)msgSmsDefTempVO);
        return ResponseUtil.success((Object)msgSmsDefTempVO);
    }

    @Override
    public ResponseData<Boolean> saveSmsDefTemp(MsgSmsDefTempSaveRequestParam requestParam) {
        AssertUtil.notNull(requestParam.getTemplateCodeCn(), requestParam.getTemplateNameCn());
        MsgSmsDefTempPO msgSmsDefTempPO = this.msgSmsDefTempService.selectOne();
        if (msgSmsDefTempPO != null) {
            return this.updateSmsDefTemp(requestParam, msgSmsDefTempPO);
        }
        return this.addSmsDefTemp(requestParam);
    }

    private ResponseData updateSmsDefTemp(MsgSmsDefTempSaveRequestParam requestParam, MsgSmsDefTempPO msgSmsDefTempPO) {
        OptUserDTO optUser = this.optUserService.getOptUser();
        MsgSmsDefTempPO msgSmsDefTempPOUpdate = new MsgSmsDefTempPO();
        BeanUtils.copyProperties((Object)requestParam, (Object)msgSmsDefTempPOUpdate);
        msgSmsDefTempPOUpdate.setMsgSmsDefTempCode(msgSmsDefTempPO.getMsgSmsDefTempCode());
        msgSmsDefTempPOUpdate.setModifiedUserCode(optUser.getOptUserCode());
        msgSmsDefTempPOUpdate.setModifiedUserName(optUser.getOptUserName());
        Boolean result = this.msgSmsDefTempService.updatePO(msgSmsDefTempPOUpdate);
        return ResponseUtil.success((Object)result);
    }

    private ResponseData addSmsDefTemp(MsgSmsDefTempSaveRequestParam requestParam) {
        OptUserDTO optUser = this.optUserService.getOptUser();
        MsgSmsDefTempPO msgSmsDefTempPOAdd = new MsgSmsDefTempPO();
        BeanUtils.copyProperties((Object)requestParam, (Object)msgSmsDefTempPOAdd);
        msgSmsDefTempPOAdd.setMsgSmsDefTempCode(UID.getUid());
        msgSmsDefTempPOAdd.setCreateUserCode(optUser.getOptUserCode());
        msgSmsDefTempPOAdd.setCreateUserName(optUser.getOptUserName());
        Boolean result = this.msgSmsDefTempService.addPO(msgSmsDefTempPOAdd);
        return ResponseUtil.success((Object)result);
    }

    public MsgSmsDefTempWrapperServiceImpl(IMsgSmsDefTempService msgSmsDefTempService, OptUserService optUserService) {
        this.msgSmsDefTempService = msgSmsDefTempService;
        this.optUserService = optUserService;
    }
}

