/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.message.api.service.MsgSendTimeService;
import com.bizvane.message.api.util.ConvertUtil;
import com.bizvane.message.domain.model.entity.MsgSendtimePO;
import com.bizvane.message.domain.service.IMsgSendtimeService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.message.feign.vo.sendtime.SendTimeAddRequestVO;
import com.bizvane.message.feign.vo.sendtime.SendTimeAddResponseVO;
import com.bizvane.message.feign.vo.sendtime.SendTimeDetailResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.stereotype.Service;

@Service
public class MsgSendTimeWrapperServiceImpl
implements MsgSendTimeService {
    private final IMsgSendtimeService msgSendTimeService;

    @Override
    public ResponseData<SendTimeDetailResponseVO> detail() {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().orderByDesc(MsgSendtimePO::getCreateDate)).last("limit 1");
        MsgSendtimePO msgSendtimePO = (MsgSendtimePO)this.msgSendTimeService.getOne((Wrapper)queryWrapper);
        SendTimeDetailResponseVO responseVO = ConvertUtil.convertSendTimePO2VO(msgSendtimePO);
        return ResponseUtil.success((Object)responseVO);
    }

    @Override
    public ResponseData<SendTimeAddResponseVO> addOrUpdate(SendTimeAddRequestVO requestVO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().orderByDesc(MsgSendtimePO::getCreateDate)).last("limit 1");
        MsgSendtimePO msgSendtimePO = (MsgSendtimePO)this.msgSendTimeService.getOne((Wrapper)queryWrapper);
        if (msgSendtimePO == null) {
            return this.addSendTime(requestVO);
        }
        return this.updateSendTime(requestVO, msgSendtimePO);
    }

    private ResponseData updateSendTime(SendTimeAddRequestVO requestVO, MsgSendtimePO msgSendtimePO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(MsgSendtimePO::getSendTimeStart, (Object)requestVO.getSendTimeStart())).set(MsgSendtimePO::getSendTimeEnd, (Object)requestVO.getSendTimeEnd())).set(MsgSendtimePO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(MsgSendtimePO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(MsgSendtimePO::getMsgSendtimeCode, (Object)msgSendtimePO.getMsgSendtimeCode());
        boolean result = this.msgSendTimeService.update((Wrapper)updateWrapper);
        SendTimeAddResponseVO responseVO = new SendTimeAddResponseVO();
        responseVO.setOptStatus(result);
        return ResponseUtil.success((Object)responseVO);
    }

    private ResponseData addSendTime(SendTimeAddRequestVO requestVO) {
        MsgSendtimePO sendTimePOAdd = new MsgSendtimePO();
        sendTimePOAdd.setSendTimeStart(requestVO.getSendTimeStart());
        sendTimePOAdd.setSendTimeEnd(requestVO.getSendTimeEnd());
        sendTimePOAdd.setMsgSendtimeCode(UID.getUid());
        sendTimePOAdd.setCreateUserCode(requestVO.getOptUserCode());
        sendTimePOAdd.setCreateUserName(requestVO.getOptUserName());
        boolean result = this.msgSendTimeService.save((Object)sendTimePOAdd);
        SendTimeAddResponseVO responseVO = new SendTimeAddResponseVO();
        responseVO.setOptStatus(result);
        return ResponseUtil.success((Object)responseVO);
    }

    public MsgSendTimeWrapperServiceImpl(IMsgSendtimeService msgSendTimeService) {
        this.msgSendTimeService = msgSendTimeService;
    }
}

