/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service;

import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.common.bean.SmsReqBean;
import com.bizvane.base.common.enums.ChannleTypeEnum;
import com.bizvane.base.remote.dto.TemplateDto;
import com.bizvane.base.remote.service.IRemoteMessageService;
import com.bizvane.base.remote.service.IRemoteTemplateService;
import com.bizvane.message.api.model.dto.config.OptUserDTO;
import com.bizvane.message.api.model.vo.sms.MsgSmsSentResponseVO;
import com.bizvane.message.api.model.vo.sms.SmsWrapperVO;
import com.bizvane.message.api.model.vo.sms.mq.SmsResendMessageVO;
import com.bizvane.message.api.model.vo.sms.param.SmsParamBaseVO;
import com.bizvane.message.api.service.MsgSmsMessageService;
import com.bizvane.message.api.service.OptUserService;
import com.bizvane.message.api.service.RemoteTemplateWrapperService;
import com.bizvane.message.api.service.RocketMQBusinessService;
import com.bizvane.message.domain.enums.SmsTemplateTypeEnum;
import com.bizvane.message.domain.enums.msg.MsgSmsSendStateEnum;
import com.bizvane.message.domain.enums.msg.MsgTemplateTypeEnum;
import com.bizvane.message.domain.model.bo.MsgSmsTempQueryBO;
import com.bizvane.message.domain.model.entity.MsgSmsSentBatchPO;
import com.bizvane.message.domain.model.entity.MsgSmsSentRecordPO;
import com.bizvane.message.domain.model.entity.MsgSmsTempPO;
import com.bizvane.message.domain.service.IMsgSmsSentBatchService;
import com.bizvane.message.domain.service.IMsgSmsSentRecordService;
import com.bizvane.message.domain.service.IMsgSmsTempService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public abstract class SmsMessageHelp<P extends SmsParamBaseVO>
implements MsgSmsMessageService<P> {
    private final IMsgSmsTempService smsTempService;
    private final RemoteTemplateWrapperService remoteTemplateWrapperService;
    private final IRemoteTemplateService remoteTemplateService;
    private final OptUserService optUserService;
    private final IMsgSmsSentBatchService msgSmsSentBatchService;
    private final IMsgSmsSentRecordService msgSmsSentRecordService;
    private final IRemoteMessageService remoteMessageService;
    private final RocketMQBusinessService rocketMQBusinessService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResponseData<MsgSmsSentResponseVO> sendSms(SmsWrapperVO<P> smsWrapperVO) {
        MsgSmsTempPO smsTempPO = this.selectSmsTemp(smsWrapperVO);
        if (smsTempPO == null) {
            String failMessage = String.format("\u672a\u914d\u7f6e\u77ed\u4fe1\u6a21\u677f:%s", smsWrapperVO.getTemplateTypeEnum().getDesc());
            return ResponseUtil.fail((String)failMessage);
        }
        String merchantId = this.selectMerchantId(smsWrapperVO);
        if (StringUtils.isBlank((CharSequence)merchantId)) {
            String failMessage = String.format("\u672a\u914d\u7f6e\u77ed\u4fe1\u5546\u6237:%s", smsWrapperVO.getTemplateTypeEnum().getDesc());
            return ResponseUtil.fail((String)failMessage);
        }
        String channelType = this.selectChannelType(smsWrapperVO);
        if (StringUtils.isBlank((CharSequence)channelType)) {
            String failMessage = String.format("\u672a\u914d\u7f6e\u6e20\u9053\u7c7b\u578b:%s", smsWrapperVO.getTemplateTypeEnum().getDesc());
            return ResponseUtil.fail((String)failMessage);
        }
        ResultBean<TemplateDto> templateDtoResultBean = this.selectGatewayTemplate(merchantId, channelType, smsTempPO.getTemplateCode());
        if (!templateDtoResultBean.getSuccess().booleanValue()) {
            String failMessage = String.format("\u77ed\u4fe1\u6a21\u677f\u4e0d\u5b58\u5728:%s", smsWrapperVO.getTemplateTypeEnum().getDesc());
            return ResponseUtil.fail((String)failMessage);
        }
        TemplateDto templateDto = (TemplateDto)templateDtoResultBean.getResult();
        MsgSmsSentBatchPO msgSmsSentBatch = null;
        msgSmsSentBatch = StringUtils.isBlank((CharSequence)smsWrapperVO.getMsgSmsSentBatchCode()) ? this.saveMsgSmsSentBatch(smsWrapperVO, templateDto) : this.getMsgSmsSentBatch(smsWrapperVO);
        if (msgSmsSentBatch == null) {
            String failMessage = String.format("\u6d88\u606f\u6279\u6b21\u8bb0\u5f55\u4e0d\u5b58\u5728:%s", smsWrapperVO.getTemplateTypeEnum().getDesc());
            return ResponseUtil.fail((String)failMessage);
        }
        List<MsgSmsSentRecordPO> msgSmsSentRecordList = this.getAndSaveMsgSmsSentRecordPO(msgSmsSentBatch, smsWrapperVO);
        if (smsWrapperVO.isSyncStatus()) {
            return this.syncSendMessage(smsWrapperVO, merchantId, channelType, templateDto, msgSmsSentBatch, msgSmsSentRecordList);
        }
        return this.asyncSendMessage(smsWrapperVO, merchantId, channelType, templateDto, msgSmsSentBatch, msgSmsSentRecordList);
    }

    @Override
    public ResponseData<MsgSmsSentResponseVO> resendMessage(SmsResendMessageVO smsResendMessageVO) {
        String msgSmsSentBatchCode = smsResendMessageVO.getMsgSmsSentBatchCode();
        MsgSmsSentBatchPO msgSmsSentBatch = this.msgSmsSentBatchService.selectByCode(msgSmsSentBatchCode);
        List<String> msgSmsSentRecordCodeList = smsResendMessageVO.getMsgSmsSentRecordCodeList();
        List msgSmsSentRecordList = this.msgSmsSentRecordService.listByCodes(msgSmsSentRecordCodeList);
        LinkedList<String> phones = new LinkedList<String>();
        LinkedList<LinkedHashMap> params = new LinkedList<LinkedHashMap>();
        for (int i = 0; i < msgSmsSentRecordList.size(); ++i) {
            MsgSmsSentRecordPO msgSmsSentRecordPO = (MsgSmsSentRecordPO)msgSmsSentRecordList.get(i);
            phones.add(msgSmsSentRecordPO.getPhone());
            LinkedHashMap param = (LinkedHashMap)JSON.parseObject((String)msgSmsSentRecordPO.getParam(), LinkedHashMap.class);
            params.add(param);
        }
        String merchantId = smsResendMessageVO.getMerchantId();
        TemplateDto templateDto = smsResendMessageVO.getTemplateDto();
        String channelType = smsResendMessageVO.getChannelType();
        ResultBean<String> stringResultBean = this.sendSmsSync(params, phones, merchantId, templateDto, channelType, msgSmsSentBatch);
        ResponseData<MsgSmsSentResponseVO> responseData = null;
        responseData = stringResultBean.getSuccess() != false ? this.smsSending(msgSmsSentBatch, msgSmsSentRecordList) : this.smsSentFail(msgSmsSentBatch, msgSmsSentRecordList, stringResultBean);
        return responseData;
    }

    protected MsgSmsTempPO selectSmsTemp(SmsWrapperVO<P> smsWrapperVO) {
        MsgSmsTempQueryBO msgSmsTempQueryBO = new MsgSmsTempQueryBO();
        msgSmsTempQueryBO.setTemplateType(smsWrapperVO.getTemplateTypeEnum().getCode());
        MsgSmsTempPO smsTempPO = this.smsTempService.selectOne(msgSmsTempQueryBO);
        return smsTempPO;
    }

    protected String selectMerchantId(SmsWrapperVO<P> smsWrapperVO) {
        return this.remoteTemplateWrapperService.getMerchantId();
    }

    protected String selectChannelType(SmsWrapperVO<P> smsWrapperVO) {
        return ChannleTypeEnum.ALIYUN.getChannelType();
    }

    protected ResultBean<TemplateDto> selectGatewayTemplate(String merchantId, String channelType, String templateCode) {
        ResultBean templateDtoResultBean = this.remoteTemplateService.queryTemplate(merchantId, channelType, templateCode);
        return templateDtoResultBean;
    }

    protected MsgSmsSentBatchPO saveMsgSmsSentBatch(SmsWrapperVO<P> smsWrapperVO, TemplateDto templateDto) {
        MsgTemplateTypeEnum msgTemplateTypeEnum = smsWrapperVO.getTemplateTypeEnum();
        OptUserDTO optUser = this.optUserService.getOptUser();
        MsgSmsSentBatchPO msgSmsSentBatchPO = new MsgSmsSentBatchPO();
        msgSmsSentBatchPO.setMsgSmsSentBatchCode(UID.getUid());
        msgSmsSentBatchPO.setTemplateType(msgTemplateTypeEnum.getCode());
        msgSmsSentBatchPO.setBusinessType(msgTemplateTypeEnum.getBusinessTypeEnum().getCode());
        msgSmsSentBatchPO.setSmsTemplateCode(templateDto.getTemplateCode());
        msgSmsSentBatchPO.setSmsTemplateName(templateDto.getTemplateName());
        msgSmsSentBatchPO.setSmsTemplateType(Integer.valueOf(templateDto.getTemplateType()));
        msgSmsSentBatchPO.setTotal(this.getMessageTotal(smsWrapperVO));
        msgSmsSentBatchPO.setCreateUserCode(optUser.getOptUserCode());
        msgSmsSentBatchPO.setCreateUserName(optUser.getOptUserName());
        this.msgSmsSentBatchService.save((Object)msgSmsSentBatchPO);
        return msgSmsSentBatchPO;
    }

    protected MsgSmsSentBatchPO getMsgSmsSentBatch(SmsWrapperVO<P> smsWrapperVO) {
        MsgSmsSentBatchPO msgSmsSentBatchPO = this.msgSmsSentBatchService.selectByCode(smsWrapperVO.getMsgSmsSentBatchCode());
        return msgSmsSentBatchPO;
    }

    protected Integer getMessageTotal(SmsWrapperVO<P> smsWrapperVO) {
        return smsWrapperVO.getParams().size();
    }

    protected List<MsgSmsSentRecordPO> getAndSaveMsgSmsSentRecordPO(MsgSmsSentBatchPO msgSmsSentBatch, SmsWrapperVO<P> smsWrapperVO) {
        OptUserDTO optUser = this.optUserService.getOptUser();
        LinkedList<MsgSmsSentRecordPO> smsSentRecordPOS = new LinkedList<MsgSmsSentRecordPO>();
        LinkedList<String> phones = smsWrapperVO.getPhones();
        LinkedList<P> params = smsWrapperVO.getParams();
        for (int i = 0; i < phones.size(); ++i) {
            String phone = phones.get(i);
            SmsParamBaseVO param = (SmsParamBaseVO)params.get(i);
            LinkedHashMap<String, String> paramMap = this.convertParamMap(param);
            MsgSmsSentRecordPO msgSmsSentRecordPO = new MsgSmsSentRecordPO();
            msgSmsSentRecordPO.setMsgSmsSentRecordCode(UID.getUid());
            msgSmsSentRecordPO.setMsgSmsSentBatchCode(msgSmsSentBatch.getMsgSmsSentBatchCode());
            msgSmsSentRecordPO.setSmsTemplateName(msgSmsSentBatch.getSmsTemplateName());
            msgSmsSentRecordPO.setSmsTemplateCode(msgSmsSentBatch.getSmsTemplateCode());
            msgSmsSentRecordPO.setSmsTemplateType(msgSmsSentBatch.getSmsTemplateType());
            msgSmsSentRecordPO.setTemplateType(msgSmsSentBatch.getTemplateType());
            msgSmsSentRecordPO.setBusinessType(msgSmsSentBatch.getBusinessType());
            msgSmsSentRecordPO.setSendState(MsgSmsSendStateEnum.DEFAULT.getCode());
            msgSmsSentRecordPO.setCreateUserCode(optUser.getOptUserCode());
            msgSmsSentRecordPO.setCreateUserName(optUser.getOptUserName());
            msgSmsSentRecordPO.setPhone(phone);
            msgSmsSentRecordPO.setParam(paramMap.toString());
            smsSentRecordPOS.add(msgSmsSentRecordPO);
        }
        this.msgSmsSentRecordService.saveBatch(smsSentRecordPOS);
        return smsSentRecordPOS;
    }

    protected ResultBean<String> sendSmsSync(LinkedList<?> params, LinkedList<String> phones, String merchantId, TemplateDto templateDto, String channelType, MsgSmsSentBatchPO msgSmsSentBatch) {
        SmsReqBean smsReqBean = new SmsReqBean();
        smsReqBean.setMerchantId(merchantId);
        smsReqBean.setPhones(phones);
        smsReqBean.setTemplateCode(templateDto.getTemplateCode());
        String signature = this.remoteTemplateWrapperService.getSignature();
        ArrayList<String> signatures = new ArrayList<String>();
        signatures.add(signature);
        smsReqBean.setSignatures(signatures);
        smsReqBean.setChannelType(channelType);
        smsReqBean.setBatchid(msgSmsSentBatch.getMsgSmsSentBatchCode());
        ArrayList<LinkedHashMap<String, String>> paramsMap = new ArrayList<LinkedHashMap<String, String>>();
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            paramsMap.add(this.convertParamMap(param));
        }
        smsReqBean.setParams(paramsMap);
        String templateType = templateDto.getTemplateType();
        SmsTemplateTypeEnum smsTemplateTypeEnum = SmsTemplateTypeEnum.typeOf((String)templateType);
        switch (smsTemplateTypeEnum) {
            case SMS_YZ: {
                return this.remoteMessageService.varCodeSms(smsReqBean);
            }
            case SMS_YX: {
                return this.remoteMessageService.marketingSms(smsReqBean);
            }
        }
        return this.remoteMessageService.noticeSms(smsReqBean);
    }

    protected LinkedHashMap<String, String> convertParamMap(Object param) {
        return (LinkedHashMap)JSON.parseObject((String)JSON.toJSONString((Object)param), LinkedHashMap.class);
    }

    protected ResponseData<MsgSmsSentResponseVO> asyncSendMessage(SmsWrapperVO<P> smsWrapperVO, String merchantId, String channelType, TemplateDto templateDto, MsgSmsSentBatchPO msgSmsSentBatch, List<MsgSmsSentRecordPO> msgSmsSentRecordList) {
        MsgSmsSentResponseVO msgSmsSentResponseVO = new MsgSmsSentResponseVO();
        msgSmsSentResponseVO.setMsgSmsSentBatchCode(msgSmsSentBatch.getMsgSmsSentBatchCode());
        List<String> msgSmsSentRecordCodeList = msgSmsSentRecordList.stream().map(MsgSmsSentRecordPO::getMsgSmsSentRecordCode).collect(Collectors.toList());
        SmsResendMessageVO smsResendMessageVO = new SmsResendMessageVO();
        smsResendMessageVO.setMsgSmsSentBatchCode(msgSmsSentBatch.getMsgSmsSentBatchCode());
        smsResendMessageVO.setMsgSmsSentRecordCodeList(msgSmsSentRecordCodeList);
        smsResendMessageVO.setChannelType(channelType);
        smsResendMessageVO.setMerchantId(merchantId);
        smsResendMessageVO.setTemplateDto(templateDto);
        SendResult sendResult = this.rocketMQBusinessService.sendSmsMessage(smsResendMessageVO);
        msgSmsSentResponseVO.setMsgId(sendResult.getMsgId());
        return ResponseUtil.success((Object)msgSmsSentResponseVO);
    }

    protected ResponseData<MsgSmsSentResponseVO> syncSendMessage(SmsWrapperVO<P> smsWrapperVO, String merchantId, String channelType, TemplateDto templateDto, MsgSmsSentBatchPO msgSmsSentBatch, List<MsgSmsSentRecordPO> msgSmsSentRecordList) {
        ResultBean<String> stringResultBean = this.sendSmsSync(smsWrapperVO.getParams(), smsWrapperVO.getPhones(), merchantId, templateDto, channelType, msgSmsSentBatch);
        ResponseData<MsgSmsSentResponseVO> responseData = null;
        responseData = stringResultBean.getSuccess() != false ? this.smsSending(msgSmsSentBatch, msgSmsSentRecordList) : this.smsSentFail(msgSmsSentBatch, msgSmsSentRecordList, stringResultBean);
        return responseData;
    }

    protected ResponseData<MsgSmsSentResponseVO> smsSentFail(MsgSmsSentBatchPO querySentBatch, List<MsgSmsSentRecordPO> msgSmsSentRecordList, ResultBean<String> stringResultBean) {
        String sendResult = stringResultBean.getErrorInfo().getMsg();
        String failDetail = stringResultBean.getErrorInfo().getMsg();
        List msgSmsSentRecordCodeList = msgSmsSentRecordList.stream().map(MsgSmsSentRecordPO::getMsgSmsSentRecordCode).collect(Collectors.toList());
        this.msgSmsSentRecordService.updateStatusByCodes(sendResult, MsgSmsSendStateEnum.FAIL.getCode(), failDetail, msgSmsSentRecordCodeList);
        this.msgSmsSentBatchService.updateFailCountByCode(querySentBatch.getMsgSmsSentBatchCode(), Integer.valueOf(1));
        return ResponseUtil.fail((String)("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25:" + stringResultBean.getErrorInfo().getMsg()));
    }

    protected ResponseData<MsgSmsSentResponseVO> smsSending(MsgSmsSentBatchPO querySentBatch, List<MsgSmsSentRecordPO> querySentRecordList) {
        MsgSmsSentResponseVO msgSmsSentResponseVO = new MsgSmsSentResponseVO();
        msgSmsSentResponseVO.setMsgSmsSentBatchCode(querySentBatch.getMsgSmsSentBatchCode());
        List msgSmsSentRecordCodeList = querySentRecordList.stream().map(MsgSmsSentRecordPO::getMsgSmsSentRecordCode).collect(Collectors.toList());
        this.msgSmsSentRecordService.updateStatusByCodes("\u540c\u6b65\u4e2d", MsgSmsSendStateEnum.IN_SYNC.getCode(), null, msgSmsSentRecordCodeList);
        return ResponseUtil.success((Object)msgSmsSentResponseVO);
    }

    public SmsMessageHelp(IMsgSmsTempService smsTempService, RemoteTemplateWrapperService remoteTemplateWrapperService, IRemoteTemplateService remoteTemplateService, OptUserService optUserService, IMsgSmsSentBatchService msgSmsSentBatchService, IMsgSmsSentRecordService msgSmsSentRecordService, IRemoteMessageService remoteMessageService, RocketMQBusinessService rocketMQBusinessService) {
        this.smsTempService = smsTempService;
        this.remoteTemplateWrapperService = remoteTemplateWrapperService;
        this.remoteTemplateService = remoteTemplateService;
        this.optUserService = optUserService;
        this.msgSmsSentBatchService = msgSmsSentBatchService;
        this.msgSmsSentRecordService = msgSmsSentRecordService;
        this.remoteMessageService = remoteMessageService;
        this.rocketMQBusinessService = rocketMQBusinessService;
    }
}

