package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponCalculateDiscountAmountRequestParam {

    @NotBlank
    @ApiModelProperty("券号")
    private String couponNo;

    @NotBlank
    @ApiModelProperty("核销机场编号")
    private String useAirportNo;

    @NotBlank
    @ApiModelProperty("核销业态编号")
    private String useIndustryNo;

    @NotBlank
    @ApiModelProperty("核销商户编号")
    private String useMerchantNo;

    @ApiModelProperty("券使用订单号")
    private String useBusinessCode;

    @NotNull
    @ApiModelProperty("订单金额")
    private BigDecimal orderAmount;

    @NotNull
    @ApiModelProperty("订单原价")
    private BigDecimal orderTagPrice;

}
