package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class OrderBO {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @NotBlank
    @ApiModelProperty("订单号")
    private String orderNo;

    @NotNull
    @ApiModelProperty("订单标志：1-订单，2-退单")
    private Integer orderFlag;

    @ApiModelProperty("原始订单号")
    private String originalOrderNo;

    @ApiModelProperty("原始订单下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime originalPlaceOrderTime;

    @ApiModelProperty("订单状态：1-待付款, 2-待发货, 3-已发货, 4-已签收, 5-交易成功, 6-退款中, 7-退款成功, 8-交易关闭")
    private Integer orderStatus;

    @ApiModelProperty("订单金额")
    private BigDecimal tradeAmount;

    @ApiModelProperty("下单时间")
    @NotNull
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime placeOrderTime;

    @ApiModelProperty("支付时间 ")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime payTime;

    @ApiModelProperty("完成时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime finishTime;

    @NotNull
    @ApiModelProperty("支付金额")
    private BigDecimal payMoney;

    @NotBlank
    @ApiModelProperty("机场编号")
    private String airportNo;

    @NotBlank
    @ApiModelProperty("行业")
    private String industryNo;

    @NotBlank
    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty(value = "消费渠道")
    private String channelCode;

    @ApiModelProperty(value = "消费来源")
    private String sourceCode;

    @ApiModelProperty("创建人code")
    private String userCode;

    @ApiModelProperty("创建人")
    private String userName;

    @NotEmpty
    private List<OrderDetailBO> orderDetailList;

    private List<OrderPaymentBO> orderPaymentList;
}
