package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class MbrGroupTypeDefAddRequestParam {

    @ApiModelProperty("分组目录名称")
    @NotBlank(message = "分组类型名称不能为空")
    private String groupTypeName;

    @ApiModelProperty("层级：1-一级目录，2-二级目录")
    @NotNull(message = "分组目录层级不能为空")
    private Integer level;

    @ApiModelProperty("父分组目录code")
    private String parentGroupTypeCode;

    @ApiModelProperty("操作人code")
    private String userCode;

    @ApiModelProperty("操作人")
    private String userName;
}
