package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class OrderDetailBO {

    @NotBlank
    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品图片")
    private String imageUrl;

    @ApiModelProperty("商品编号")
    private String productNo;

    @ApiModelProperty("规格")
    private String specification;

    @ApiModelProperty("购买数量")
    private BigDecimal quantityDecimal;

    @ApiModelProperty("吊牌价")
    private BigDecimal tagPrice;

    @ApiModelProperty("折扣价")
    private BigDecimal discountPrice;

    @ApiModelProperty("成交价（成交价 = 折扣价 = 吊牌价x折扣率）")
    private BigDecimal tradeAmountDetail;

    @ApiModelProperty("订单详情成交价总金额(trade_amount_detail*数量)")
    private BigDecimal tradeDetailTotalAmount;

}
