package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

@Data
public class MbrOpenCardRequestParam {

    @NotBlank
    @ApiModelProperty("手机号加密")
    private String phoneEncrypt;

    @NotBlank
    @ApiModelProperty("脱敏手机号")
    private String phoneMask;

    @ApiModelProperty("微信openid")
    private String openId;

    @ApiModelProperty("微信unioinid")
    private String unionId;

    @ApiModelProperty("渠道code")
    private String channelCode;

    @ApiModelProperty("来源code取自SourceEnum枚举表")
    private String sourceCode;

    @ApiModelProperty("注册机场code")
    private String airportCode;

    @ApiModelProperty("注册详情类型：1-楼宇，2-商户，3-渠道码")
    private Integer detailType;

    @ApiModelProperty("注册详情code")
    private String detailCode;

    @ApiModelProperty("会员名称")
    private String name;

    @ApiModelProperty("会员性别,女:1 男:2 未知:3")
    private String gender;

    @ApiModelProperty("会员邮箱")
    private String email;

    @ApiModelProperty("会员生日")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime birthday;

    @ApiModelProperty("会员省份")
    private String province;

    @ApiModelProperty("会员市区")
    private String city;

    @ApiModelProperty("会员县")
    private String county;

    @ApiModelProperty("详细地址")
    private String address;

    @ApiModelProperty("会员头像")
    private String headPortraits;

    @ApiModelProperty("开卡时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime openCardTime;

    @ApiModelProperty(value = "开卡链路traceCode")
    private String traceCode;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人id")
    private String userCode;

    @ApiModelProperty("创建人")
    private String userName;

}
