package com.bizvane.members.facade.es.pojo.qywx;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.bizvane.members.facade.models.po.EsMbrFriends;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode
public class WxQyFriendsPojo implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	
	public WxQyFriendsPojo(EsMbrFriends po) {
		super();
		this.esMbrFriendsId = po.getEsMbrFriendsId();
		this.sysCompanyId = po.getSysCompanyId();
		this.brandId = po.getBrandId();
		this.externalUserId = po.getExternalUserId();
		this.guideId = po.getGuideId();
		this.friendsComment = po.getFriendsComment();
		this.externalType = po.getExternalType() == null ? null : po.getExternalType().toString();
		this.unionId = po.getUnionId();
		this.externalName = po.getExternalName();
		this.headPortraits = po.getHeadPortraits();
		this.gender = StringUtils.isNotBlank(po.getGender()) ? Integer.valueOf(po.getGender()) : null;
		this.memberCode = po.getMemberCode();
		this.levelId = po.getLevelId();
		this.serviceStoreId = po.getServiceStoreId();
		this.serviceGuideId = po.getServiceGuideId();
		this.focus = po.getFocus();
		this.phone = po.getPhone();
		this.memberName = po.getMemberName();
		this.createDate = po.getCreateDate();
		this.friendStatus = po.getFriendStatus();
		this.storeId = po.getStoreId() == null ? null : po.getStoreId().toString();
		this.exclusiveFriend = po.getExclusiveFriend();
	}

	
	public WxQyFriendsPojo() {
		super();
	}


	private Long esMbrFriendsId;
	private Long sysCompanyId;
	private Long brandId;
	private String externalUserId;
	private Long guideId;

	private String friendsComment;
	private String externalType;
	private String unionId;
	private String externalName;
	private String headPortraits;
	private Integer gender;
	private String memberCode;

	private Long levelId;
	// 等级名称
	private String levelName;

	private Long serviceStoreId;
	private Long serviceGuideId;

	private Integer focus;
	private String phone;
	private String memberName;
	
	private Date createDate;

	private Integer friendStatus;

    /**
     * 关系导购门店id
     */
    private String storeId;

	/**
	 * 专属好友关系
	 */
	private Boolean exclusiveFriend;
}
