package com.bizvane.members.facade.vo;

import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.SelectCacheKeyVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class MembersSysVo {

    @ApiModelProperty(value = "会员体系id", name = "memberSysDefId", example = "会员体系id")
    private Long memberSysDefId;

    @ApiModelProperty(value = "会员体系编号", name = "memberSysCode", example = "会员体系编号")
    private String memberSysCode;

    @ApiModelProperty(value = "所属企业", name = "sysCompanyId", example = "所属企业")
    private Long sysCompanyId;

    @ApiModelProperty(value = "归属品牌", name = "brandId", example = "归属品牌")
    private Long brandId;


    @ApiModelProperty(value = "开卡门店id", name = "openCardStoreId", example = "开卡门店id")
    private Long openCardStoreId;

    @ApiModelProperty(value = "开卡等级id", name = "newLevelId", example = "开卡等级id")
    private Long newLevelId;


    @ApiModelProperty(value = "1=线上 2=线下", name = "canOnLine", example = "canOnLine")
    private Integer canOnLine;

    //2019-08-10新加
    @ApiModelProperty(value = "默认开卡导购", name = "openCardGuideId")
    private Long openCardGuideId;


    @ApiModelProperty(value = "默认开卡门店", name = "defaultStoreName", example = "默认开卡门店")
    private String defaultStoreName;


    @ApiModelProperty(value = "默认开卡导购", name = "openCardGuideName")
    private String openCardGuideName;

    @ApiModelProperty(value = "开启默认门店是否变更。0：不开启，1：开启",name = "enableChangeMemberFirstStore")
    private Boolean enableChangeMemberFirstStore;

    @ApiModelProperty(value = "开启默认门店是否变更。0：不开启，1：开启",name = "enableChangeMemberFirstStore")
    private Integer levelUpTimePoint;

    @ApiModelProperty(value = " 首次消费变更所属店铺范围店铺id集合（，分割）",name = "selectStoreIds")
    private String selectStoreIds;

    @ApiModelProperty(value = "店铺数据集合",name = "selectStoreIds")
    private List<SysStorePo> selectStoreList;

    @ApiModelProperty(value = "开启默认导购是否变更。0：不开启，1：开启", name = "enableChangeMemberFirstGuide")
    private Boolean enableChangeMemberFirstGuide;

    @ApiModelProperty(value = "开启绑定是否变更店铺导购。0：不开启，1：开启", name = "enableChangeMemberBindGuide")
    private Boolean enableChangeMemberBindGuide;

    @ApiModelProperty(value = "中台组件使用,门店key", name = "selectCacheKeyVo")
    private SelectCacheKeyVo selectCacheKeyVo;

    //降级设置
    @ApiModelProperty(value = "年")
    private String year;
    @ApiModelProperty(value = "月")
    private String month;
    @ApiModelProperty(value = "日")
    private String day;
    @ApiModelProperty(value = "保级状态 0=未开始  1=已开始")
    private Integer keepStatus;
    @ApiModelProperty(value = "保护期时长针对升级")
    private Integer protectTime = 0;
    @ApiModelProperty(value = "降级保护开关针对升级 0关 1开")
    private Integer switchToProtect = 0;
    @ApiModelProperty(value = "降级任务开关 0关闭 1开启")
    private Integer switchToDown = 0;
    @ApiModelProperty(value = "时间模式。0=日历模式，1=每日定时模式")
    private Boolean timeModel;
    @ApiModelProperty(value = "每日定时模式下开始执行日期")
    private String startTime;
    @ApiModelProperty(value = "降级保护开关针对降级 0关 1开")
    private Integer switchToProtectLess = 0;
    @ApiModelProperty(value = "保护期时长针对降级")
    private Integer protectTimeLess = 0;

    @ApiModelProperty(value = "付费会员卡升级开关 false 关闭 true 开启")
    private Boolean paidMembershipUpgradeSwitch;
}
