package com.bizvane.members.facade.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
@Data
public class MemberLastBuyOrderVo implements Serializable {
    private static final long serialVersionUID = -4035289225369846561L;

    @ApiModelProperty(value = "订单主键", name = "mbrOrderId", example = "订单主键")
    private Long mbrOrderId;

    @ApiModelProperty(value = "所属会员", name = "memberCode", example = "所属会员")
    private String memberCode;

    @ApiModelProperty(value = "所属企业id", name = "sysCompanyId", example = "所属企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "服务门店", name = "serviceStoreId", example = "服务门店")
    private Long serviceStoreId;

    @ApiModelProperty(value = "服务门店名", name = "serviceStoreName", example = "服务门店名")
    private String serviceStoreName;

    @ApiModelProperty(value = "订单门店线下code", name = "serviceStoreCode", example = "订单门店线下code")
    private String serviceStoreCode;

    @ApiModelProperty(value = "下单时间", name = "placeOrderTime", example = "下单时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date placeOrderTime;

    @ApiModelProperty(value = "账单时间", name = "billTime", example = "账单时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date billTime;

    @ApiModelProperty(value = "支付金额", name = "payMoney", example = "支付金额")
    private BigDecimal payMoney;

    @ApiModelProperty(value = "成交金额(优惠卷+抵扣卷)", name = "tradeAmount", example = "成交金额(优惠卷+抵扣卷)")
    private BigDecimal tradeAmount;

    @ApiModelProperty(value = "商品名称", name = "productNameList", example = "商品名称")
    private List<String> productNameList;
}
