package com.bizvane.members.facade.service.inner;


import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberLabelTypeModel;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * @author houkai
 */
public interface MemberLabelGroupService {
    /**
     * 添加标签组
     *
     * @param memberLabelTypeModel
     * @return
     * @throws MemberException
     */
    ResponseData addLabelGroup(MemberLabelTypeModel memberLabelTypeModel) throws MemberException;

    /**
     * 查询企业品牌下所有标签组
     *
     * @param brandId
     * @param labelCategory
     * @return
     */
    ResponseData<List<MemberLabelTypeModel>> queryLabelGroupList(long brandId, String labelCategory);

    /**
     * 编辑标签组
     *
     * @param memberLabelTypeModel
     * @return
     * @throws MemberException
     */
    ResponseData updateLabelGroupValid(MemberLabelTypeModel memberLabelTypeModel) throws MemberException;

    /**
     * 初始化标签管理页面
     *
     * @param brandId
     * @return
     */
    ResponseData queryLabelView(long brandId);

    /**
     * 查询标签分组详情
     *
     * @param labelGroupId
     * @return
     */
    ResponseData<MemberLabelTypeModel> queryLabelGroupInfo(long labelGroupId);

    /**
     * 编辑标签组
     *
     * @param memberLabelTypeModel
     * @return
     */
    ResponseData updateLabelGroup(MemberLabelTypeModel memberLabelTypeModel);

    ResponseData updateLabelGroupListSort(String customs, long brandId);

    /**
     * 根据标签id 更新企微标签id
     * @param sysBrandId
     * @param mbrLabelGroupDefId
     * @param wxqyTagGroupId
     * @return
     */
    ResponseData<String> updateTagGroupIdByMbrLabelGroupId(Long sysBrandId, Long mbrLabelGroupDefId, String wxqyTagGroupId);

    ResponseData<String> deleteByWxqyTagGroupId(Long sysBrandId, String wxqyTagGroupId);

    ResponseData<MemberLabelTypeModel> getMbrLabelGroupById(Long mbrLabelGroupId);

    ResponseData<List<MemberLabelTypeModel>> getMbrLabelGroupByIdList(List<Long> mbrLabelGroupIdList);

    ResponseData<List<MemberLabelTypeModel>> getMbrLabelGroupBySysBrandId(Long sysBrandId);

    ResponseData<MemberLabelTypeModel> getMbrLabelGroupByWxqyCorpGroupId(Long sysBrandId, String wxqyCorpGroupId);

    ResponseData<String> syncWxqyCorpTagByMbrLabelGroup(Long sysBrandId, Long mbrLabelGroupId);

    void syncWxqyCorpTagByMbrLabelGroupAll(Long sysBrandId);
}
