package com.bizvane.members.facade.enums;

import org.elasticsearch.search.sort.SortOrder;

/***
 * 会员es排序方式
 */
public enum MemberSortEnum {
    /**
     * 深度分页排序 默认排序
     */
    defaultSort("默认排序[主键增序排序]", SortOrder.ASC, "mbrMemberId"),
    /**
     * 深度分页排序 主键降序排序
     */
    mbrMemberIdDesc("主键降序排序", SortOrder.DESC, "mbrMemberId"),
    /**
     * 深度分页排序 开卡时间增序排序
     */
    openCardTimeAsc("开卡时间增序排序", SortOrder.ASC, "openCardTime"),
    /**
     * 深度分页排序 开卡时间降序排序
     */
    openCardTimeDesc("开卡时间降序排序", SortOrder.DESC, "openCardTime");

    private SortOrder sortOrder;

    private String sortField;

    MemberSortEnum(String description, SortOrder sortOrder, String sortField) {

        this.sortOrder = sortOrder;
        this.sortField = sortField;

    }

    public SortOrder getSortOrder() {
        return sortOrder;
    }

    public String getSortField() {
        return sortField;
    }

}
