package com.bizvane.members.facade.vo.qywx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author baofeng@bizvane.cn
 * @createTime 2022-09-08 11:51:42
 * @description: 商品秀导购分享分页列表查询请求对象
 */
@ApiModel(value = "商品秀导购分享分页列表查询请求对象")
@Getter
@Setter
@Builder
public class MallShareRecordListRequestVO {

    @NotNull(message = "企业ID不能为空")
    @ApiModelProperty(name = "sysCompanyId", value = "企业ID", required = true, example = "1L")
    private Long sysCompanyId;

    @NotNull(message = "品牌ID不能为空")
    @ApiModelProperty(name = "sysBrandId", value = "品牌ID", required = true, example = "1L")
    private Long sysBrandId;

    @NotNull(message = "查询类型不能为空")
    @ApiModelProperty(name = "queryType", value = "查询类型,1-商品; 2-其他", required = true, example = "1")
    private Integer queryType;

    @NotBlank(message = "导购Code不能为空")
    @ApiModelProperty(name = "staffCode", value = "导购Code", required = true, example = "")
    private String staffCode;

    @ApiModelProperty(name = "pageNo", value = "当前页数", required = false, example = "1")
    private Integer pageNo = 1;

    @ApiModelProperty(name = "pageSize", value = "显示条数", required = false, example = "10")
    private Integer pageSize = 10;

}
