package com.bizvane.members.facade.models.query;

import lombok.*;


/**
 * 会员资产查询 入参
 */
@Data
@Builder
@EqualsAndHashCode
@NoArgsConstructor
@AllArgsConstructor
public class MemberAssetsCounterRequestPo {

    private Long sysCompanyId;

    private Long sysBrandId;

    /**
     * 会员标识: 1.会员 2.非会员
     */
    private Integer memberIdentity;

    /**
     * 线上导购id
     */
    private Long guideId;

    /**
     * 线上门店id
     */
    private Long storeId;

    /**
     *  '是否关注,1：未关注,2：已关注,3:已取关'
     */
    private Integer focus;



    /**
     * 会员身份
     */
    public enum MemberIdentityEnum {
        member(1), nonMember(2);

        private Integer code;

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        MemberIdentityEnum(Integer code) {
            this.code = code;
        }
    }

}
