package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.models.MbrRechargeCardUpdateVo;
import com.bizvane.members.facade.models.MbrRechargeCardVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zcc
 * @date 2022/2/17 11:41
 **/
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MbrRechargeCardRpcService {

    /**
     * 查询会员储值卡信息列表
     *
     * @param sysCompanyId
     * @param sysBrandId
     * @param memberCode
     * @param cardSourceType
     * @return
     */
    @RequestMapping(value = "/api/queryMbrRechargeCardList", method = RequestMethod.POST)
    ResponseData<List<MbrRechargeCardVo>> queryMbrRechargeCardList(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId, @RequestParam("memberCode") String memberCode, @RequestParam(value = "cardSourceType", required = false) Integer cardSourceType);

    /**
     * 根据卡归属类型查询会员储值卡信息
     *
     * @param sysCompanyId
     * @param sysBrandId
     * @param memberCode
     * @param cardSourceType
     * @param organizationCode
     * @return
     */
    @RequestMapping(value = "/api/queryMbrRechargeCardByOrg", method = RequestMethod.POST)
    ResponseData<MbrRechargeCardVo> queryMbrRechargeCardByOrg(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId, @RequestParam("memberCode") String memberCode, @RequestParam("cardSourceType") Integer cardSourceType, @RequestParam(value = "organizationCode", required = false) String organizationCode);

    /**
     * 根据储值卡卡号查询储值卡信息
     *
     * @param sysCompanyId
     * @param sysBrandId
     * @param memberCode
     * @param petCardNo
     * @return
     */
    @RequestMapping(value = "/api/queryMbrRechargeCard", method = RequestMethod.POST)
    ResponseData<MbrRechargeCardVo> queryMbrRechargeCardByPetCardNo(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId, @RequestParam("memberCode") String memberCode, @RequestParam("petCardNo") String petCardNo);

    /**
     * 修改储值卡余额,发消息
     * @param mbrRechargeCardUpdateVo
     * @return
     */
    @RequestMapping(value = "/api/updateMbrRechargeCardBalanceAndSendTempalte", method = RequestMethod.POST)
    ResponseData<String> updateMbrRechargeCardBalanceAndSendTempalte(@RequestBody MbrRechargeCardUpdateVo mbrRechargeCardUpdateVo);

    /**
     * 修改储值卡余额
     * @param mbrRechargeCardUpdateVo
     * @return
     */
    @RequestMapping(value = "/api/updateMbrRechargeCardBalance", method = RequestMethod.POST)
    ResponseData<String> updateMbrRechargeCardBalance(@RequestBody MbrRechargeCardUpdateVo mbrRechargeCardUpdateVo);
}
