package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/17.
 * 会员积分
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_integral")
public class IntegralModel extends BaseModel implements Serializable {


    private static final long serialVersionUID = 2981808559430799980L;

    @Id
    @ApiModelProperty(value = "积分id", name = "integralId")
    private Long integralId;

    @ApiModelProperty(value = "会员code", name = "memberCode")
    private String memberCode;

    @ApiModelProperty(value = "累计收入积分", name = "totalIncomeIntegral")
    private Integer totalIncomeIntegral;
    
    @ApiModelProperty(value = "累计可用积分", name = "usableIntegral")
    private Integer usableIntegral;
}
