/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.utils;

import com.bizvane.members.facade.utils.EncryptPhoneProperties;
import com.bizvane.members.facade.utils.PhoneEncryptUtil;
import com.bizvane.utils.redisutils.SpringContextHolder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneEncryptConfig {
    private static final Logger log = LoggerFactory.getLogger(PhoneEncryptConfig.class);

    public static String encryptAES(Long sysCompanyId, String data) {
        log.info("\u52a0\u5bc6\u5f00\u59cb:{},{}", (Object)sysCompanyId, (Object)data);
        EncryptPhoneProperties properties = (EncryptPhoneProperties)SpringContextHolder.getBean(EncryptPhoneProperties.class);
        if (properties == null) {
            log.error("\u52a0\u5bc6\u914d\u7f6e\u4e3a\u7a7a:{}", (Object)data);
            return data;
        }
        log.info("\u52a0\u5bc6\u914d\u7f6e:{}", (Object)properties);
        if (StringUtils.isBlank((CharSequence)data)) {
            log.info("\u52a0\u5bc6\u6570\u636e\u4e3a\u7a7a:");
            return data;
        }
        if (sysCompanyId == null || CollectionUtils.isEmpty(properties.getSysCompanyIdList())) {
            log.info("\u52a0\u5bc6\u6570\u636e\u4f01\u4e1a\u4e3a\u7a7a:{}", (Object)sysCompanyId);
            return data;
        }
        if (!properties.getSysCompanyIdList().contains(sysCompanyId)) {
            log.info("\u52a0\u5bc6\u6570\u636e\u4f01\u4e1a\u672a\u5f00\u542f:{}", (Object)sysCompanyId);
            return data;
        }
        try {
            return PhoneEncryptUtil.encryptAES(properties.getKey(), properties.getIv(), data);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u5931\u8d25:", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return data;
        }
    }

    public static String decryptAES(Long sysCompanyId, String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return data;
        }
        EncryptPhoneProperties properties = (EncryptPhoneProperties)SpringContextHolder.getBean(EncryptPhoneProperties.class);
        if (properties == null) {
            return data;
        }
        if (sysCompanyId == null || CollectionUtils.isEmpty(properties.getSysCompanyIdList())) {
            return data;
        }
        if (!properties.getSysCompanyIdList().contains(sysCompanyId)) {
            return data;
        }
        try {
            return PhoneEncryptUtil.decryptAES(properties.getKey(), properties.getIv(), data);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5931\u8d25:", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return data;
        }
    }
}

