package com.bizvane.members.facade.enums.tree3;

public enum Tree3AutoLabelTypeEnum {

    /**
     * 类型 0: 直接调整
     */
    DIRECT_ADJUST(0, "直接调整"),

    /**
     * 类型 1: 开卡
     */
    CARD_REGISTRATION(1, "开卡"),

    /**
     * 类型 2: 绑卡
     */
    CARD_BINDING(2, "绑卡"),

    /**
     * 类型 3: 订单同步
     */
    ORDER_SYNC(3, "订单同步"),

    /**
     * 类型 4: 扫会员中心导购码/门店码
     */
    SCAN_GUIDE_STORE_CODE(4, "扫会员中心导购码/门店码"),

    /**
     * 类型 5: 扫四会活动签到码
     */
    SCAN_EVENT_CHECKIN_CODE(5, "扫四会活动签到码");

    private final int code;
    private final String description;

    Tree3AutoLabelTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据code获取对应的枚举类型
     *
     * @param code 类型编码
     * @return 对应的枚举类型，未找到时返回null
     */
    public static Tree3AutoLabelTypeEnum fromCode(int code) {
        for (Tree3AutoLabelTypeEnum type : values()) {
            if (type.getCode() == code) {
                return type;
            }
        }
        return null;
    }
}
