package com.bizvane.members.facade.enums.tree3;

public enum Tree3AutoLabelSyncStatusEnum {

    /**
     * 同步状态 0: 同步中
     */
    SYNC_IN_PROGRESS(0, "同步中"),

    /**
     * 同步状态 1: 同步成功
     */
    SYNC_SUCCESS(1, "同步成功"),

    /**
     * 同步状态 2: 同步失败
     */
    SYNC_FAILED(2, "同步失败");

    private final int code;
    private final String description;

    Tree3AutoLabelSyncStatusEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据code获取对应的枚举类型
     *
     * @param code 状态编码
     * @return 对应的枚举类型，未找到时返回null
     */
    public static Tree3AutoLabelSyncStatusEnum fromCode(int code) {
        for (Tree3AutoLabelSyncStatusEnum status : values()) {
            if (status.getCode() == code) {
                return status;
            }
        }
        return null;
    }
}
