package com.bizvane.members.facade.vo.tree3;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
@Data
public class TMbrGrowthRecordThreetreeVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("pk")
    @TableId(value = "mbr_growth_record_threetree_id", type = IdType.AUTO)
    private Long mbrGrowthRecordThreetreeId;

    @ApiModelProperty("企业id")
    private Long sysCompanyId;

    @ApiModelProperty("品牌id")
    private Long sysBrandId;

    @ApiModelProperty("渠道code")
    private String channelCode;

    @ApiModelProperty("事业部")
    private String offlineOrgCode;

    @ApiModelProperty("事业部名称")
    private String offlineOrgName;

    @ApiModelProperty("会员memberCode")
    private String memberCode;

    @ApiModelProperty("成长值 退单等场景可能为负")
    private Integer growthNum;

    @ApiModelProperty("成长值获取时间 与创建时间不一定一致")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime growthTime;

    @ApiModelProperty("来源类型1订单，2开放平台接口")
    private Integer sourceType;

    @ApiModelProperty("来源单据号：订单号等")
    private String sourceBill;

    @ApiModelProperty("备注 预留给手动调整等场景使用")
    private String remark;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;

    @ApiModelProperty("创建人id")
    private Long createUserId;

    @ApiModelProperty("创建人姓名")
    private String createUserName;

    @ApiModelProperty("数据有效性")
    private Integer valid;
}
