package com.bizvane.members.facade.vo.tree3;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class TMbrGrowthRecordThreetreeAddReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("企业id")
    @NotNull
    private Long sysCompanyId;

    @ApiModelProperty("品牌id")
    @NotNull
    private Long sysBrandId;

    @ApiModelProperty("渠道code")
    @NotBlank
    private String channelCode;

    @ApiModelProperty("事业部")
    private String offlineOrgCode;

    @ApiModelProperty("会员memberCode")
    @NotBlank
    private String memberCode;

    @ApiModelProperty("成长值 退单等场景可能为负")
    @NotNull
    private Integer growthNum;

    @ApiModelProperty("成长值获取时间 与创建时间不一定一致")
    @NotNull
    private LocalDateTime growthTime;

    @ApiModelProperty("来源类型1订单，2开放平台接口")
    @NotNull
    private Integer sourceType;

    @ApiModelProperty("来源单据号：订单号等")
    @NotBlank
    private String sourceBill;

    @ApiModelProperty("备注 预留给手动调整等场景使用")
    private String remark;

}
