package com.bizvane.members.facade.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
public class ChannelSourceRecordRequest {

    public ChannelSourceRecordRequest(Long sysCompanyId, Long sysBrandId, String offlineOrgCode, String memberCode, String sourceCode, Integer recordType, Date recordDate) {
        this.sysCompanyId = sysCompanyId;
        this.sysBrandId = sysBrandId;
        this.offlineOrgCode = offlineOrgCode;
        this.memberCode = memberCode;
        this.sourceCode = sourceCode;
        this.recordType = recordType;
        this.recordDate = recordDate;
    }

    public ChannelSourceRecordRequest(Long sysCompanyId, Long sysBrandId, String memberCode, String sourceCode, Integer recordType, Date recordDate) {
        this.sysCompanyId = sysCompanyId;
        this.sysBrandId = sysBrandId;
        this.memberCode = memberCode;
        this.sourceCode = sourceCode;
        this.recordType = recordType;
        this.recordDate = recordDate;
    }

    public ChannelSourceRecordRequest() {
    }
    @NotNull
    private Long sysCompanyId; //是 long 公司id openApi补
    @NotNull
    private Long sysBrandId;//是 string 公司线下code openApi补

    @ApiModelProperty("事业部code")
    private String offlineOrgCode;

    @NotNull
    private String memberCode;//	是	string	品牌

    @NotNull
    private String sourceCode;
    @ApiModelProperty(value = "记录类型：0，开卡；1，绑卡；",name = "recordType")
    private Integer recordType;

    @ApiModelProperty(value = "记录时间",name = "recordDate")
    private Date recordDate;

}
