package com.bizvane.members.facade.service.card.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.constraints.NotEmpty;
import java.util.Date;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/17.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode
public class IntegralChangeRequestModel {

    @ApiModelProperty(name = "sysCompanyId", value = "公司id")
    private Long sysCompanyId;

    @ApiModelProperty(name = "brandId", value = "品牌Id")
    private Long brandId;

    @ApiModelProperty("渠道code")
    private String channelCode;

    @ApiModelProperty("渠道id")
    private Long sysChannelId;

    @ApiModelProperty("事业部code")
    private String offlineOrgCode;

    @ApiModelProperty(name = "memberCode", value = "会员code")
    private String memberCode;

    @ApiModelProperty(name = "changeBills", value = "变更单据")
    private String changeBills;

    @ApiModelProperty(name = "cardNo", value = "会员卡号")
    private String cardNo;

    @ApiModelProperty(name = "offlineCardNo", value = "线下会员卡号")
    private String offlineCardNo;

    @ApiModelProperty(name = "changeIntegral", value = "调整积分数量")
    private Integer changeIntegral;

    @ApiModelProperty(value = "变更时间", name = "changeDate", example = "变更时间")
    private Date changeDate;

    @ApiModelProperty(name = "changeType", value = "调整类型")
    private String changeType;

    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    @ApiModelProperty(name = "changeDetails", value = "积分调整详情")
    private String changeDetails;

    @ApiModelProperty(name = "operateUserId", value = "操作人id")
    private Long operateUserId;

    @ApiModelProperty(name = "operateUserName", value = "操作人姓名")
    private String operateUserName;

    @ApiModelProperty(name = "pointsAmount", value = "积分数额")
    private Integer pointsAmount;

    @ApiModelProperty(name = "storeId", value = "门店id")
    private String storeId;

    @ApiModelProperty(name = "source", value = "积分来源")
    private String source;

    @ApiModelProperty(name = "pointsIdUnique", value = "积分流水唯一标志")
    private String pointsIdUnique;

    @ApiModelProperty(name = "phone", value = "用户手机号")
    private String phone;

    @ApiModelProperty(name = "allChannelIds", value = "用户渠道，用于有赞积分消息推送判断")
    private String allChannelIds;

    private String taoBaoNick;

    private String onlineStoreCode;

    @ApiModelProperty(name = "maVersionCode", value = "CDP营销流程版本编号")
    private String maVersionCode;

    @ApiModelProperty(name = "maPlanCode", value = "CDP营销流程编号")
    private String maPlanCode;

    @ApiModelProperty(name = "maPlanName", value = "CDP营销流程名称")
    private String maPlanName;

    @ApiModelProperty(name = "maPlanNodeCode", value = "CDP营销流程节点编号")
    private String maPlanNodeCode;

    @ApiModelProperty(name = "maPlanNodeName", value = "CDP营销流程批次号")
    private String maBatchNumber;

    @ApiModelProperty(name = "maBatchSerialNumber", value = "CDP营销流程发送时生成的批次内的唯一序号")
    private String maBatchSerialNumber;
}
