package com.bizvane.members.facade.es.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class GroupMixMembersInfoSearchVo {
    @NotNull
    private Long sysCompanyId;

    @NotNull
    private Long brandId;

    private MembersInfoSearchVo membersInfoSearchVo;

    @NotNull
    private Integer pageNumber;

    @NotNull
    private Integer pageSize;

    @ApiModelProperty(value = "会员范围:1微信会员，2全部会员", name = "memberScope")
    private String memberScope;

    @ApiModelProperty(name = "wxMembers", value = "1微信会员，2不是微信会员")
    private Integer wxMembers;

    @ApiModelProperty(value = "生日时间线", name = "birthdayLine")
    private Integer birthdayLine;

    @ApiModelProperty(value = "注册时间线", name = "openCardTimeLine")
    private Integer openCardTimeLine;

    @ApiModelProperty(value = "宝宝生日时间线", name = "babyBirthdayLine")
    private Integer babyBirthdayLine;

    @ApiModelProperty(value = "等级ID集合", name = "levelID")
    private List<Long> levelID;

    // 隔离门店
    private List<Long> storeList;

    private Long mbrGroupDefId;

    // 生日 冗余生日时间的格式月日,例如：0101
    // private List<SearchRangRequest> birthdayMD;
    private List<SearchRangRequest> birthdayMD;

    //新 生日高级搜索
    private SearchRangeTypeRequest birthdayMdRange;


    private List<SearchRangRequest> babyBirthdayMD;

    @ApiModelProperty(value = "开卡开始时间", name = "openCardDateFrom")
    private String openCardDateFrom;

    @ApiModelProperty(value = "开卡结束时间", name = "openCardDateTo")
    private String openCardDateTo;

    private String onlineOrgCode;

    private List<SearchRangRequest> mbrMemberIdRanges;

    // 会员memberCode
    private String memberCode;
    
    private String excludeMktBirthday;
}
