package com.bizvane.members.facade.models.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class MbrLevelRechargeQueryBO {
    private Long sysCompanyId;

    private Long brandId;

    private String condition;

    private Long payLevelId;

    private List<Long> storeIdList;

    private List<Long> guideIdList;

    private Integer status;

    //开始购买时间
    private Date buyTimeBegin;

    //结束购买时间
    private Date buyTimeEnd;

    //开始过期时间
    private Date expireTimeBegin;

    //结束过期时间
    private Date expireTimeEnd;

    //流水状态 0正常 1退款中 2已退款s
    private Integer recordStatus;

    // 查询类型 1：不包含退卡中的流水
    private Integer queryType;

    @ApiModelProperty(value = "付费卡类型 1-年卡 2-季卡", name = "payCardType", example = "1")
    private Integer payCardType;

}
